/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.management.stats.ServiceStatistics;
import org.mule.util.CollectionUtils;

public class DefaultServiceExceptionStrategy
extends AbstractMessagingExceptionStrategy {
    public DefaultServiceExceptionStrategy() {
    }

    public DefaultServiceExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    protected void defaultHandler(Throwable t) {
        ServiceStatistics statistics = this.getServiceStatistics();
        if (statistics != null) {
            statistics.incExecutionError();
        }
        super.defaultHandler(t);
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        ServiceStatistics statistics = this.getServiceStatistics();
        if (statistics != null) {
            statistics.incFatalError();
        }
        super.logFatal(message, t);
    }

    protected void routeException(MuleMessage message, MessageProcessor target, Throwable t) {
        super.routeException(message, target, t);
        List<MessageProcessor> processors = this.getMessageProcessors(t);
        if (CollectionUtils.isNotEmpty(processors) && this.getServiceStatistics() != null) {
            ServiceStatistics statistics = this.getServiceStatistics();
            for (MessageProcessor endpoint : processors) {
                statistics.getOutboundRouterStat().incrementRoutedMessage(endpoint);
            }
        }
    }

    protected ServiceStatistics getServiceStatistics() {
        MuleEvent event = RequestContext.getEvent();
        if (event == null) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current event on the context");
            return null;
        }
        if (event.getFlowConstruct() != null && event.getFlowConstruct() instanceof Service) {
            return ((Service)event.getFlowConstruct()).getStatistics();
        }
        this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current service on the context. Please report this to dev@mule.codehaus.org");
        return null;
    }
}

