/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.NullPayload;
import org.mule.util.ObjectUtils;

public abstract class AbstractMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandler {
    public MuleEvent handleException(Exception e, MuleEvent event) {
        if (this.enableNotifications) {
            this.fireNotification(new ExceptionNotification(e));
        }
        this.logException(e);
        this.handleTransaction(e);
        Throwable t = this.getExceptionType(e, RoutingException.class);
        if (t != null) {
            RoutingException re = (RoutingException)t;
            this.handleRoutingException(re.getMuleMessage(), re.getRoute(), e);
            event.getMessage().setPayload(NullPayload.getInstance());
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
            return event;
        }
        t = this.getExceptionType(e, MessagingException.class);
        if (t != null) {
            MessagingException me = (MessagingException)t;
            this.handleMessagingException(me.getMuleMessage(), e);
            event.getMessage().setPayload(NullPayload.getInstance());
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
            return event;
        }
        t = this.getExceptionType(e, LifecycleException.class);
        if (t != null) {
            LifecycleException le = (LifecycleException)t;
            this.handleLifecycleException(le.getComponent(), e);
            if (RequestContext.getEventContext() != null) {
                this.handleMessagingException(RequestContext.getEventContext().getMessage(), e);
            } else {
                this.logger.info((Object)"There is no current event available, routing Null message with the exception");
                this.handleMessagingException(new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext), e);
            }
            event.getMessage().setPayload(NullPayload.getInstance());
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
            return event;
        }
        this.handleStandardException(e);
        event.getMessage().setPayload(NullPayload.getInstance());
        event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
        return event;
    }

    public void handleMessagingException(MuleMessage message, Throwable t) {
        this.defaultHandler(t);
        this.routeException(this.messageFromContextIfAvailable(message), null, t);
    }

    public void handleRoutingException(MuleMessage message, MessageProcessor target, Throwable t) {
        this.defaultHandler(t);
        this.routeException(this.messageFromContextIfAvailable(message), target, t);
    }

    public void handleLifecycleException(Object component, Throwable t) {
        this.handleStandardException(t);
        this.logger.error((Object)("The object that failed was: \n" + ObjectUtils.toString((Object)component, (String)"null")));
    }

    public void handleStandardException(Throwable t) {
        if (RequestContext.getEventContext() != null) {
            this.handleMessagingException(RequestContext.getEventContext().getMessage(), t);
        } else {
            this.logger.info((Object)"There is no current event available, routing Null message with the exception");
            this.handleMessagingException(new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext), t);
        }
    }

    protected void defaultHandler(Throwable t) {
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new DefaultExceptionPayload(t));
        }
    }

    protected MuleMessage messageFromContextIfAvailable(MuleMessage message) {
        if (null != RequestContext.getEvent()) {
            return RequestContext.getEvent().getMessage();
        }
        return message;
    }
}

