/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.VoidResult;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.component.ComponentException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.management.stats.ComponentStatistics;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponent
implements Component,
MuleContextAware,
Lifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected FlowConstruct flowConstruct;
    protected ComponentStatistics statistics = null;
    protected ServerNotificationHandler notificationHandler;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected MessageProcessor interceptorChain;
    protected MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
    }

    private MuleEvent invokeInternal(MuleEvent event) throws MuleException {
        OptimizedRequestContext.unsafeSetEvent(event);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking " + this.getClass().getName() + "component for service " + this.flowConstruct.getName()));
        }
        if (!(event.getEndpoint() instanceof InboundEndpoint)) {
            throw new IllegalStateException("Unable to process outbound event, components only process incoming events.");
        }
        if (!this.flowConstruct.getLifecycleState().isStarted() || this.flowConstruct.getLifecycleState().isStopping()) {
            throw new LifecycleException(CoreMessages.isStopped(this.flowConstruct.getName()), (Object)this);
        }
        try {
            this.fireComponentNotification(event.getMessage(), 1401);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            Object result = this.doInvoke(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            MuleEvent resultEvent = this.createResultEvent(event, result);
            resultEvent.setStopFurtherProcessing(event.isStopFurtherProcessing());
            this.fireComponentNotification(resultEvent.getMessage(), 1402);
            return resultEvent;
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ComponentException(CoreMessages.failedToInvoke(this.toString()), event, (Component)this, (Throwable)e);
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.interceptorChain == null) {
            return this.invokeInternal(event);
        }
        return this.interceptorChain.process(event);
    }

    protected MuleEvent createResultEvent(MuleEvent event, Object result) throws MuleException {
        if (result instanceof MuleMessage) {
            return new DefaultMuleEvent((MuleMessage)result, event);
        }
        if (result instanceof VoidResult) {
            return event;
        }
        if (result != null) {
            event.getMessage().applyTransformers(event, Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event;
        }
        return new DefaultMuleEvent(new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext), event);
    }

    protected abstract Object doInvoke(MuleEvent var1) throws Exception;

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        if (this.flowConstruct != null) {
            buf.append(" component for: ").append(this.flowConstruct.toString());
        } else {
            buf.append(" no component");
        }
        return buf.toString();
    }

    public void release() {
    }

    @Override
    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (this.muleContext == null && flowConstruct.getMuleContext() != null) {
            this.muleContext = flowConstruct.getMuleContext();
        }
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public final void initialise() throws InitialisationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising: " + this));
        }
        if (this.flowConstruct == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Component has not been initialized properly, no service."), (Initialisable)this);
        }
        InterceptingChainMessageProcessorBuilder chainBuilder = new InterceptingChainMessageProcessorBuilder();
        for (Interceptor interceptor : this.interceptors) {
            chainBuilder.chain(interceptor);
        }
        chainBuilder.chain(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return AbstractComponent.this.invokeInternal(event);
            }
        });
        try {
            this.interceptorChain = chainBuilder.build();
            if (this.interceptorChain instanceof Initialisable) {
                ((Initialisable)((Object)this.interceptorChain)).initialise();
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        if (this.flowConstruct.getLifecycleState().isDisposed()) {
            return;
        }
        try {
            if (this.flowConstruct.getLifecycleState().isStarted()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)CoreMessages.failedToStop(this.toString()));
        }
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.warn(CoreMessages.failedToDispose(this.toString()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    @Override
    public void stop() throws MuleException {
        if (this.flowConstruct.getLifecycleState().isStopped()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping: " + this));
        }
        this.doStop();
    }

    protected void doStart() throws MuleException {
    }

    @Override
    public void start() throws MuleException {
        if (this.flowConstruct.getLifecycleState().isStarted()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting: " + this));
        }
        this.notificationHandler = new OptimisedNotificationHandler(this.flowConstruct.getMuleContext().getNotificationManager(), ComponentMessageNotification.class);
        this.doStart();
    }

    protected void doStop() throws MuleException {
    }

    protected void fireComponentNotification(MuleMessage message, int action) {
        if (this.notificationHandler.isNotificationEnabled(ComponentMessageNotification.class)) {
            this.notificationHandler.fireNotification(new ComponentMessageNotification(message, this, this.flowConstruct, action));
        }
    }
}

