/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.ObjectFilter;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.util.ClassUtils;

public class RegExFilter
implements Filter,
ObjectFilter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Pattern pattern;

    public RegExFilter() {
    }

    public RegExFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public boolean accept(MuleMessage message) {
        try {
            return this.accept(message.getPayloadAsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        Object tempObject = object;
        if (object instanceof byte[]) {
            ByteArrayToObject transformer = new ByteArrayToObject();
            try {
                object = transformer.transform(object);
            }
            catch (TransformerException e) {
                this.logger.warn((Object)CoreMessages.transformFailedBeforeFilter(), (Throwable)e);
                object = tempObject;
            }
        } else if (object instanceof char[]) {
            object = new String((char[])object);
        }
        return this.pattern != null && this.pattern.matcher(object.toString()).find();
    }

    public String getPattern() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public void setPattern(String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegExFilter other = (RegExFilter)obj;
        return ClassUtils.equal(this.pattern, other.pattern);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.pattern});
    }
}

