/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.routing.SelectiveRouter;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.MessageFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.routing.MessageProcessorFilterPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectiveRouter
implements SelectiveRouter,
RouterStatisticsRecorder {
    private final List<MessageProcessorFilterPair> conditionalMessageProcessors = new ArrayList<MessageProcessorFilterPair>();
    private final RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private MessageProcessor defaultProcessor;
    private RouterStatistics routerStatistics = new RouterStatistics(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(MessageProcessor processor, Filter filter) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            this.conditionalMessageProcessors.add(new MessageProcessorFilterPair(processor, filter));
        }
    }

    @Override
    public void removeRoute(MessageProcessor processor) {
        this.updateRoute(processor, new RoutesUpdater(){

            public void updateAt(int index) {
                AbstractSelectiveRouter.this.conditionalMessageProcessors.remove(index);
            }
        });
    }

    @Override
    public void updateRoute(final MessageProcessor processor, final Filter filter) {
        this.updateRoute(processor, new RoutesUpdater(){

            public void updateAt(int index) {
                AbstractSelectiveRouter.this.conditionalMessageProcessors.set(index, new MessageProcessorFilterPair(processor, filter));
            }
        });
    }

    @Override
    public void setDefaultRoute(MessageProcessor processor) {
        this.defaultProcessor = processor;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        Collection<MessageProcessor> selectedProcessors = this.selectProcessors(event);
        if (!selectedProcessors.isEmpty()) {
            return this.routeWithProcessors(selectedProcessors, event);
        }
        if (this.defaultProcessor != null) {
            return this.routeWithProcessor(this.defaultProcessor, event);
        }
        if (this.getRouterStatistics() != null) {
            this.getRouterStatistics().incrementNoRoutedMessage();
        }
        throw new RoutePathNotFoundException(MessageFactory.createStaticMessage("Can't process message because no route has been found matching any filter and no default route is defined"), event, (MessageProcessor)this);
    }

    protected abstract Collection<MessageProcessor> selectProcessors(MuleEvent var1);

    private MuleEvent routeWithProcessor(MessageProcessor processor, MuleEvent event) throws MuleException {
        return this.routeWithProcessors(Collections.singleton(processor), event);
    }

    private MuleEvent routeWithProcessors(Collection<MessageProcessor> processors, MuleEvent event) throws MuleException {
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>();
        for (MessageProcessor processor : processors) {
            this.processEventWithProcessor(event, processor, results);
        }
        return this.resultsHandler.aggregateResults(results, event, event.getMuleContext());
    }

    private void processEventWithProcessor(MuleEvent event, MessageProcessor processor, List<MuleEvent> results) throws MuleException {
        MuleEvent processedEvent = event;
        if (processor instanceof OutboundEndpoint) {
            processedEvent = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)processor, event.getSession());
        }
        results.add(processor.process(processedEvent));
        if (this.getRouterStatistics() != null) {
            this.getRouterStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    protected List<MessageProcessorFilterPair> getConditionalMessageProcessors() {
        return Collections.unmodifiableList(this.conditionalMessageProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoute(MessageProcessor processor, RoutesUpdater routesUpdater) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (int i = 0; i < this.conditionalMessageProcessors.size(); ++i) {
                if (!this.conditionalMessageProcessors.get(i).getMessageProcessor().equals(processor)) continue;
                routesUpdater.updateAt(i);
            }
        }
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static interface RoutesUpdater {
        public void updateAt(int var1);
    }
}

