/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.MatchingRouter;
import org.mule.api.routing.TransformingMatchable;
import org.mule.config.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMatchingRouter
implements MatchingRouter {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MatchableMessageProcessor> matchableRoutes = new CopyOnWriteArrayList();
    protected boolean matchAll = false;
    protected MessageProcessor defaultRoute;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        boolean matchfound = false;
        Iterator<MatchableMessageProcessor> iterator = this.matchableRoutes.iterator();
        while (iterator.hasNext()) {
            MuleEvent eventToRoute;
            MatchableMessageProcessor outboundRouter = iterator.next();
            boolean copyEvent = false;
            if (iterator.hasNext()) {
                if (this.isMatchAll()) {
                    copyEvent = true;
                } else if (outboundRouter instanceof TransformingMatchable) {
                    copyEvent = ((TransformingMatchable)((Object)outboundRouter)).isTransformBeforeMatch();
                }
            }
            if (copyEvent) {
                if (((DefaultMuleMessage)message).isConsumable()) {
                    throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), message);
                }
                eventToRoute = OptimizedRequestContext.criticalSetEvent(event);
            } else {
                eventToRoute = event;
            }
            if (!outboundRouter.isMatch(eventToRoute.getMessage())) continue;
            matchfound = true;
            MuleEvent result = outboundRouter.process(event);
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.defaultRoute != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + session.getFlowConstruct().getName() + " invoking catch all strategy"));
            }
            return this.processDefaultRoute(event);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + session.getFlowConstruct().getName() + " and there is no catch all strategy configured on this router.  Disposing message " + message));
        }
        return event;
    }

    protected MuleEvent processDefaultRoute(MuleEvent event) throws MuleException {
        return this.defaultRoute.process(event);
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    @Override
    public void addRoute(MatchableMessageProcessor matchable) {
        this.matchableRoutes.add(matchable);
    }

    @Override
    public void removeRoute(MatchableMessageProcessor matchable) {
        this.matchableRoutes.remove(matchable);
    }

    public void setDefaultRoute(MessageProcessor defaultRoute) {
        this.defaultRoute = defaultRoute;
    }

    public List<MatchableMessageProcessor> getRoutes() {
        return this.matchableRoutes;
    }

    public MessageProcessor getDefaultRoute() {
        return this.defaultRoute;
    }

    public void initialise() throws InitialisationException {
        for (MatchableMessageProcessor route : this.matchableRoutes) {
            if (!(route instanceof Initialisable)) continue;
            ((Initialisable)((Object)route)).initialise();
        }
    }

    public void dispose() {
        for (MatchableMessageProcessor route : this.matchableRoutes) {
            if (!(route instanceof Disposable)) continue;
            ((Disposable)((Object)route)).dispose();
        }
    }
}

