/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.inbound.InboundEndpointMimeTypeCheckingMessageProcessor;
import org.mule.endpoint.inbound.InboundEndpointPropertyMessageProcessor;
import org.mule.endpoint.inbound.InboundExceptionDetailsMessageProcessor;
import org.mule.endpoint.inbound.InboundLoggingMessageProcessor;
import org.mule.endpoint.inbound.InboundNotificationMessageProcessor;
import org.mule.endpoint.outbound.OutboundEndpointMimeTypeCheckingMessageProcessor;
import org.mule.endpoint.outbound.OutboundEndpointPropertyMessageProcessor;
import org.mule.endpoint.outbound.OutboundEventTimeoutMessageProcessor;
import org.mule.endpoint.outbound.OutboundLoggingMessageProcessor;
import org.mule.endpoint.outbound.OutboundResponsePropertiesMessageProcessor;
import org.mule.endpoint.outbound.OutboundRewriteResponseEventMessageProcessor;
import org.mule.endpoint.outbound.OutboundSessionHandlerMessageProcessor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.processor.ExceptionHandlingMessageProcessor;
import org.mule.processor.TransactionalInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.routing.ExceptionThrowingMessageFilter;
import org.mule.transport.AbstractConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpointMessageProcessorChainFactory
implements EndpointMessageProcessorChainFactory {
    protected List<MessageProcessor> createInboundMessageProcessors(InboundEndpoint endpoint) {
        return Arrays.asList(new ExceptionHandlingMessageProcessor(), new InboundEndpointMimeTypeCheckingMessageProcessor(endpoint), new InboundEndpointPropertyMessageProcessor(endpoint), new InboundNotificationMessageProcessor(endpoint), new InboundLoggingMessageProcessor(endpoint), new ExceptionThrowingMessageFilter(endpoint.getFilter()));
    }

    protected List<MessageProcessor> createInboundResponseMessageProcessors(InboundEndpoint endpoint) {
        return Arrays.asList(new InboundExceptionDetailsMessageProcessor(endpoint.getConnector()));
    }

    protected List<MessageProcessor> createOutboundMessageProcessors(OutboundEndpoint endpoint) throws MuleException {
        AbstractConnector connector = (AbstractConnector)endpoint.getConnector();
        ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
        list.add(new ExceptionHandlingMessageProcessor());
        list.add(new OutboundLoggingMessageProcessor());
        list.add(new ProcessIfStartedMessageProcessor(connector, connector.getLifecycleState()));
        list.add(new TransactionalInterceptingMessageProcessor(endpoint.getTransactionConfig()));
        list.add(new OutboundEventTimeoutMessageProcessor());
        list.add(new OutboundSessionHandlerMessageProcessor(connector.getSessionHandler()));
        list.add(new OutboundEndpointPropertyMessageProcessor());
        list.add(new OutboundResponsePropertiesMessageProcessor(endpoint));
        list.add(new OutboundEndpointMimeTypeCheckingMessageProcessor(endpoint));
        return list;
    }

    protected List<MessageProcessor> createOutboundResponseMessageProcessors(OutboundEndpoint endpoint) throws MuleException {
        return Arrays.asList(new OutboundRewriteResponseEventMessageProcessor());
    }

    @Override
    public MessageProcessor createInboundMessageProcessorChain(InboundEndpoint endpoint, MessageProcessor target) throws MuleException {
        InterceptingChainMessageProcessorBuilder requestChainBuilder = new InterceptingChainMessageProcessorBuilder();
        requestChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' request chain");
        requestChainBuilder.chain(this.createInboundMessageProcessors(endpoint));
        requestChainBuilder.chain(endpoint.getMessageProcessors());
        if (target == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage("No listener (target) has been set for this endpoint"));
        }
        requestChainBuilder.chain(target);
        InterceptingChainMessageProcessorBuilder responseChainBuilder = new InterceptingChainMessageProcessorBuilder();
        responseChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' response chain");
        responseChainBuilder.chain(this.createInboundResponseMessageProcessors(endpoint));
        responseChainBuilder.chain(endpoint.getResponseMessageProcessors());
        InterceptingChainMessageProcessorBuilder compositeChainBuilder = new InterceptingChainMessageProcessorBuilder();
        compositeChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' composite request/response chain");
        compositeChainBuilder.chain(requestChainBuilder.build(), responseChainBuilder.build());
        return compositeChainBuilder.build();
    }

    @Override
    public MessageProcessor createOutboundMessageProcessorChain(OutboundEndpoint endpoint, MessageProcessor target) throws MuleException {
        InterceptingChainMessageProcessorBuilder outboundChainBuilder = new InterceptingChainMessageProcessorBuilder();
        outboundChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' request chain");
        outboundChainBuilder.chain(this.createOutboundMessageProcessors(endpoint));
        outboundChainBuilder.chain(endpoint.getMessageProcessors());
        if (target == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage("No listener (target) has been set for this endpoint"));
        }
        outboundChainBuilder.chain(target);
        InterceptingChainMessageProcessorBuilder responseChainBuilder = new InterceptingChainMessageProcessorBuilder();
        responseChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' response chain");
        responseChainBuilder.chain(this.createOutboundResponseMessageProcessors(endpoint));
        responseChainBuilder.chain(endpoint.getResponseMessageProcessors());
        InterceptingChainMessageProcessorBuilder compositeChainBuilder = new InterceptingChainMessageProcessorBuilder();
        compositeChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' composite request/response chain");
        compositeChainBuilder.chain(outboundChainBuilder.build(), responseChainBuilder.build());
        return compositeChainBuilder.build();
    }
}

