/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import edu.emory.mathcs.backport.java.util.Collections;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointAwareMessageProcessor;
import org.mule.processor.SecurityFilterMessageProcessor;
import org.mule.routing.MessageFilter;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpoint
implements ImmutableEndpoint {
    private static final long serialVersionUID = -1650380871293160973L;
    protected static final Log logger = LogFactory.getLog(AbstractEndpoint.class);
    private final Connector connector;
    private final EndpointURI endpointUri;
    private final EndpointMessageProcessorChainFactory messageProcessorsFactory;
    private final List<MessageProcessor> messageProcessors;
    private final List<MessageProcessor> responseMessageProcessors;
    private MessageProcessor messageProcessorChain;
    private final String name;
    private Map properties = new HashMap();
    private final TransactionConfig transactionConfig;
    private final boolean deleteUnacceptedMessages;
    private final MessageExchangePattern messageExchangePattern;
    private final int responseTimeout;
    private final String initialState;
    private final String endpointEncoding;
    private final MuleContext muleContext;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private String endpointBuilderName;
    private final String endpointMimeType;
    private boolean disableTransportTransformer = false;

    public AbstractEndpoint(Connector connector, EndpointURI endpointUri, String name, Map properties, TransactionConfig transactionConfig, boolean deleteUnacceptedMessages, MessageExchangePattern messageExchangePattern, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors, boolean disableTransportTransformer, String endpointMimeType) {
        this.connector = connector;
        this.endpointUri = endpointUri;
        this.name = name;
        this.properties.putAll(properties);
        this.transactionConfig = transactionConfig;
        this.deleteUnacceptedMessages = deleteUnacceptedMessages;
        this.responseTimeout = responseTimeout;
        this.initialState = initialState;
        this.endpointEncoding = endpointEncoding;
        this.endpointBuilderName = endpointBuilderName;
        this.muleContext = muleContext;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.endpointMimeType = endpointMimeType;
        this.disableTransportTransformer = disableTransportTransformer;
        if (transactionConfig != null && transactionConfig.getFactory() != null && transactionConfig.getAction() != 0 && transactionConfig.getAction() != 5) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Endpoint has a transaction configuration. Defaulting to REQUEST_RESPONSE. Endpoint is: " + this.toString()));
            }
            this.messageExchangePattern = MessageExchangePattern.REQUEST_RESPONSE;
        } else {
            this.messageExchangePattern = messageExchangePattern;
        }
        this.messageProcessorsFactory = messageProcessorsFactory;
        if (messageProcessors == null) {
            this.messageProcessors = Collections.unmodifiableList((List)java.util.Collections.EMPTY_LIST);
        } else {
            messageProcessors = this.injectSelfIntoMessageProcessors(messageProcessors);
            this.messageProcessors = Collections.unmodifiableList((List)messageProcessors);
        }
        this.responseMessageProcessors = responseMessageProcessors == null ? Collections.unmodifiableList((List)java.util.Collections.EMPTY_LIST) : Collections.unmodifiableList(responseMessageProcessors);
    }

    @Override
    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    @Override
    public String getEncoding() {
        return this.endpointEncoding;
    }

    @Override
    public String getMimeType() {
        return this.endpointMimeType;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.messageProcessorsFactory;
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.responseMessageProcessors;
    }

    @Override
    public List<Transformer> getTransformers() {
        LinkedList<Transformer> transformers = new LinkedList<Transformer>();
        for (MessageProcessor processor : this.messageProcessors) {
            if (!(processor instanceof Transformer)) continue;
            transformers.add((Transformer)processor);
        }
        return transformers;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = new StringBuffer(uri.getScheme()).append("://").append(sanitizerMatcher.group(1)).append(":<password>").append("@").append(uri.getHost()).append(uri.getRawPath()).toString();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ",  name='" + this.name + "', mep=" + (Object)((Object)this.messageExchangePattern) + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialState=" + this.initialState + ", responseTimeout=" + this.responseTimeout + ", endpointEncoding=" + this.endpointEncoding + ", disableTransportTransformer=" + this.disableTransportTransformer + "}";
    }

    @Override
    public String getProtocol() {
        return this.connector.getProtocol();
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpoint other = (AbstractEndpoint)obj;
        return AbstractEndpoint.equal(this.retryPolicyTemplate, other.retryPolicyTemplate) && AbstractEndpoint.equal(this.connector, other.connector) && this.deleteUnacceptedMessages == other.deleteUnacceptedMessages && AbstractEndpoint.equal(this.endpointEncoding, other.endpointEncoding) && AbstractEndpoint.equal(this.endpointUri, other.endpointUri) && AbstractEndpoint.equal(this.initialState, other.initialState) && AbstractEndpoint.equal((Object)this.messageExchangePattern, (Object)other.messageExchangePattern) && AbstractEndpoint.equal(this.name, other.name) && AbstractEndpoint.equal(this.properties, other.properties) && this.responseTimeout == other.responseTimeout && AbstractEndpoint.equal(this.messageProcessors, other.messageProcessors) && AbstractEndpoint.equal(this.responseMessageProcessors, other.responseMessageProcessors) && AbstractEndpoint.equal(this.transactionConfig, other.transactionConfig) && this.disableTransportTransformer == other.disableTransportTransformer;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.retryPolicyTemplate, this.connector, this.deleteUnacceptedMessages ? Boolean.TRUE : Boolean.FALSE, this.endpointEncoding, this.endpointUri, this.initialState, this.messageExchangePattern, this.name, this.properties, this.responseTimeout, this.responseMessageProcessors, this.transactionConfig, this.messageProcessors, this.disableTransportTransformer ? Boolean.TRUE : Boolean.FALSE});
    }

    @Override
    public Filter getFilter() {
        for (MessageProcessor mp : this.messageProcessors) {
            if (!(mp instanceof MessageFilter)) continue;
            return ((MessageFilter)mp).getFilter();
        }
        return null;
    }

    @Override
    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    @Override
    public EndpointSecurityFilter getSecurityFilter() {
        for (MessageProcessor mp : this.messageProcessors) {
            if (!(mp instanceof SecurityFilterMessageProcessor)) continue;
            return ((SecurityFilterMessageProcessor)mp).getFilter();
        }
        return null;
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.messageExchangePattern;
    }

    @Override
    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public String getInitialState() {
        return this.initialState;
    }

    @Override
    public List<Transformer> getResponseTransformers() {
        LinkedList<Transformer> transformers = new LinkedList<Transformer>();
        for (MessageProcessor processor : this.responseMessageProcessors) {
            if (!(processor instanceof Transformer)) continue;
            transformers.add((Transformer)processor);
        }
        return transformers;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    @Override
    public String getEndpointBuilderName() {
        return this.endpointBuilderName;
    }

    @Override
    public boolean isProtocolSupported(String protocol) {
        return this.connector.supportsProtocol(protocol);
    }

    @Override
    public boolean isDisableTransportTransformer() {
        return this.disableTransportTransformer;
    }

    public MessageProcessor getMessageProcessorChain() throws MuleException {
        if (this.messageProcessorChain == null) {
            this.messageProcessorChain = this.createMessageProcessorChain();
        }
        return this.messageProcessorChain;
    }

    protected abstract MessageProcessor createMessageProcessorChain() throws MuleException;

    private List injectSelfIntoMessageProcessors(List<MessageProcessor> messageProcessors) {
        if (!CollectionUtils.containsType(messageProcessors, EndpointAwareMessageProcessor.class)) {
            return messageProcessors;
        }
        ArrayList<MessageProcessor> newMessageProcessors = new ArrayList<MessageProcessor>(messageProcessors.size());
        for (MessageProcessor mp : messageProcessors) {
            if (!(mp instanceof EndpointAwareMessageProcessor)) {
                newMessageProcessors.add(mp);
                continue;
            }
            MessageProcessor newMp = ((EndpointAwareMessageProcessor)mp).injectEndpoint(this);
            if (newMp == null) continue;
            newMessageProcessors.add(newMp);
        }
        return newMessageProcessors;
    }
}

