/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.IOException;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueInfo;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.DefaultXASession;

class TransactionalQueueSession
extends DefaultXASession
implements QueueSession {
    protected TransactionalQueueManager queueManager;

    public TransactionalQueueSession(AbstractXAResourceManager resourceManager, TransactionalQueueManager queueManager) {
        super(resourceManager);
        this.queueManager = queueManager;
    }

    public Queue getQueue(String name) {
        QueueInfo queue = this.queueManager.getQueue(name);
        return new QueueImpl(queue);
    }

    protected class QueueImpl
    implements Queue {
        protected QueueInfo queue;

        public QueueImpl(QueueInfo queue) {
            this.queue = queue;
        }

        public void put(Object item) throws InterruptedException {
            this.offer(item, Long.MAX_VALUE);
        }

        public boolean offer(Object item, long timeout) throws InterruptedException {
            if (TransactionalQueueSession.this.localContext != null) {
                return ((TransactionalQueueManager.QueueTransactionContext)TransactionalQueueSession.this.localContext).offer(this.queue, item, timeout);
            }
            try {
                Object id = TransactionalQueueSession.this.queueManager.doStore(this.queue, item);
                try {
                    if (!this.queue.offer(id, 0, timeout)) {
                        TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                        return false;
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    throw e;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object take() throws InterruptedException {
            return this.poll(Long.MAX_VALUE);
        }

        public void untake(Object item) throws InterruptedException {
            this.queue.untake(item);
        }

        public Object poll(long timeout) throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null) {
                    return ((TransactionalQueueManager.QueueTransactionContext)TransactionalQueueSession.this.localContext).poll(this.queue, timeout);
                }
                Object id = this.queue.poll(timeout);
                if (id != null) {
                    Object item = TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                    TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    return item;
                }
                return null;
            }
            catch (InterruptedException iex) {
                if (TransactionalQueueSession.this.queueManager.getMuleContext().isStopping()) {
                    throw iex;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object peek() throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null) {
                    return ((TransactionalQueueManager.QueueTransactionContext)TransactionalQueueSession.this.localContext).peek(this.queue);
                }
                Object id = this.queue.peek();
                if (id != null) {
                    return TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int size() {
            if (TransactionalQueueSession.this.localContext != null) {
                return ((TransactionalQueueManager.QueueTransactionContext)TransactionalQueueSession.this.localContext).size(this.queue);
            }
            return this.queue.list.size();
        }

        public String getName() {
            return this.queue.getName();
        }
    }
}

