/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.service;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.UrlEndpointURIBuilder;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransportServiceDescriptor
extends AbstractServiceDescriptor
implements TransportServiceDescriptor {
    private String connector;
    private String dispatcherFactory;
    private String requesterFactory;
    private String transactionFactory;
    private String messageFactory;
    private String messageReceiver;
    private String transactedMessageReceiver;
    private String xaTransactedMessageReceiver;
    private String endpointUriBuilder;
    private String sessionHandler;
    private String defaultInboundTransformer;
    private String defaultOutboundTransformer;
    private String defaultResponseTransformer;
    private String endpointBuilder;
    private final AtomicReference inboundTransformer = new AtomicReference();
    private final AtomicReference outboundTransformer = new AtomicReference();
    private final AtomicReference responseTransformer = new AtomicReference();
    private Properties exceptionMappings = new Properties();
    private MuleContext muleContext;
    private ClassLoader classLoader;

    public DefaultTransportServiceDescriptor(String service, Properties props, ClassLoader classLoader) {
        super(service);
        this.classLoader = classLoader;
        this.init(props);
    }

    protected void init(Properties props) {
        this.connector = this.removeProperty("connector", props);
        this.dispatcherFactory = this.removeProperty("dispatcher.factory", props);
        this.requesterFactory = this.removeProperty("requester.factory", props);
        this.transactionFactory = this.removeProperty("dispatcher.factory", props);
        this.messageReceiver = this.removeProperty("message.receiver", props);
        this.transactedMessageReceiver = this.removeProperty("transacted.message.receiver", props);
        this.xaTransactedMessageReceiver = this.removeProperty("xa.transacted.message.receiver", props);
        this.messageFactory = this.removeProperty("message.factory", props);
        this.defaultInboundTransformer = this.removeProperty("inbound.transformer", props);
        this.defaultOutboundTransformer = this.removeProperty("outbound.transformer", props);
        this.defaultResponseTransformer = this.removeProperty("response.transformer", props);
        this.endpointBuilder = this.removeProperty("meta.endpoint.builder", props);
        this.endpointUriBuilder = this.removeProperty("endpoint.builder", props);
        this.sessionHandler = this.removeProperty("session.handler", props);
    }

    public void setOverrides(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.connector = props.getProperty("connector", this.connector);
        this.dispatcherFactory = props.getProperty("dispatcher.factory", this.dispatcherFactory);
        this.requesterFactory = props.getProperty("requester.factory", this.requesterFactory);
        this.messageReceiver = props.getProperty("message.receiver", this.messageReceiver);
        this.transactedMessageReceiver = props.getProperty("transacted.message.receiver", this.transactedMessageReceiver);
        this.xaTransactedMessageReceiver = props.getProperty("xa.transacted.message.receiver", this.xaTransactedMessageReceiver);
        this.messageFactory = props.getProperty("message.factory", this.messageFactory);
        this.endpointBuilder = props.getProperty("meta.endpoint.builder", this.endpointBuilder);
        String temp = props.getProperty("inbound.transformer");
        if (temp != null) {
            this.defaultInboundTransformer = temp;
            this.inboundTransformer.set(null);
        }
        if ((temp = props.getProperty("outbound.transformer")) != null) {
            this.defaultOutboundTransformer = temp;
            this.outboundTransformer.set(null);
        }
        if ((temp = props.getProperty("response.transformer")) != null) {
            this.defaultResponseTransformer = temp;
            this.responseTransformer.set(null);
        }
        if ((temp = props.getProperty("endpoint.builder")) != null) {
            this.endpointUriBuilder = temp;
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public MuleMessageFactory createMuleMessageFactory() throws TransportServiceException {
        if (this.messageFactory == null) {
            throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Factory", this.getService()));
        }
        try {
            return (MuleMessageFactory)ClassUtils.instanciateClass(this.messageFactory, this.muleContext);
        }
        catch (Exception e) {
            throw new TransportServiceException(CoreMessages.failedToCreate("Message Factory"));
        }
    }

    @Override
    public SessionHandler createSessionHandler() throws TransportServiceException {
        if (this.sessionHandler == null) {
            this.sessionHandler = SerializeAndEncodeSessionHandler.class.getName();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No session.handler set in service description, defaulting to: " + this.sessionHandler));
            }
        }
        try {
            return (SessionHandler)ClassUtils.instanciateClass(this.sessionHandler, ClassUtils.NO_ARGS, this.classLoader);
        }
        catch (Throwable e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("SessionHandler", this.sessionHandler), e);
        }
    }

    @Override
    public MessageReceiver createMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws MuleException {
        MessageReceiver mr = this.createMessageReceiver(connector, flowConstruct, endpoint, null);
        return mr;
    }

    @Override
    public MessageReceiver createMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, Object[] args) throws MuleException {
        String receiverClass = this.messageReceiver;
        if (endpoint.getTransactionConfig().isTransacted()) {
            boolean xaTx = endpoint.getTransactionConfig().getFactory() instanceof XaTransactionFactory;
            if (this.transactedMessageReceiver != null && !xaTx) {
                receiverClass = this.transactedMessageReceiver;
            } else if (this.xaTransactedMessageReceiver != null && xaTx) {
                receiverClass = this.xaTransactedMessageReceiver;
            }
        }
        if (receiverClass != null) {
            Object[] newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, flowConstruct, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                MessageReceiver mr = (MessageReceiver)ClassUtils.instanciateClass(receiverClass, newArgs, this.classLoader);
                return mr;
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getService()), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Receiver", this.getService()));
    }

    @Override
    public MessageDispatcherFactory createDispatcherFactory() throws TransportServiceException {
        if (this.dispatcherFactory != null) {
            try {
                return (MessageDispatcherFactory)ClassUtils.instanciateClass(this.dispatcherFactory, ClassUtils.NO_ARGS, this.classLoader);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Dispatcher Factory", this.dispatcherFactory), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public MessageRequesterFactory createRequesterFactory() throws TransportServiceException {
        if (this.requesterFactory != null) {
            try {
                return (MessageRequesterFactory)ClassUtils.instanciateClass(this.requesterFactory, ClassUtils.NO_ARGS, this.classLoader);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Requester Factory", this.requesterFactory), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public TransactionFactory createTransactionFactory() throws TransportServiceException {
        if (this.transactionFactory != null) {
            try {
                return (TransactionFactory)ClassUtils.instanciateClass(this.transactionFactory, ClassUtils.NO_ARGS, this.classLoader);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Transaction Factory", this.transactionFactory), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Connector createConnector() throws TransportServiceException {
        Connector newConnector;
        try {
            if (this.connector == null) {
                throw new TransportServiceException(CoreMessages.objectNotSetInService("Connector", this.getService()));
            }
            Class connectorClass = this.classLoader != null ? ClassUtils.loadClass(this.connector, this.classLoader) : ClassUtils.loadClass(this.connector, this.getClass());
            newConnector = (Connector)connectorClass.getConstructor(MuleContext.class).newInstance(this.muleContext);
        }
        catch (TransportServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Connector", this.connector), (Throwable)e);
        }
        if (newConnector.getName() == null) {
            newConnector.setName("_" + newConnector.getProtocol() + "Connector#" + this.connector.hashCode());
        }
        return newConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transformer> createInboundTransformers() throws TransportFactoryException {
        if (this.inboundTransformer.get() != null) {
            return CollectionUtils.singletonList(this.inboundTransformer.get());
        }
        if (this.defaultInboundTransformer != null) {
            this.logger.info((Object)("Loading default inbound transformer: " + this.defaultInboundTransformer));
            try {
                AtomicReference atomicReference = this.inboundTransformer;
                synchronized (atomicReference) {
                    if (this.inboundTransformer.get() == null) {
                        Transformer newTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultInboundTransformer, ClassUtils.NO_ARGS, this.classLoader);
                        newTransformer.setName(newTransformer.getName() + "#" + this.hashCode());
                        this.muleContext.getRegistry().registerObject(newTransformer.getName(), newTransformer);
                        this.inboundTransformer.compareAndSet(null, (Object)newTransformer);
                    }
                }
                return CollectionUtils.singletonList(this.inboundTransformer.get());
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("inbound", this.defaultInboundTransformer), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transformer> createOutboundTransformers() throws TransportFactoryException {
        if (this.outboundTransformer.get() != null) {
            return CollectionUtils.singletonList(this.outboundTransformer.get());
        }
        if (this.defaultOutboundTransformer != null) {
            this.logger.info((Object)("Loading default outbound transformer: " + this.defaultOutboundTransformer));
            try {
                AtomicReference atomicReference = this.outboundTransformer;
                synchronized (atomicReference) {
                    if (this.outboundTransformer.get() == null) {
                        Transformer newTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultOutboundTransformer, ClassUtils.NO_ARGS, this.classLoader);
                        newTransformer.setName(newTransformer.getName() + "#" + this.hashCode());
                        this.muleContext.getRegistry().registerObject(newTransformer.getName(), newTransformer);
                        this.outboundTransformer.compareAndSet(null, (Object)newTransformer);
                    }
                }
                return CollectionUtils.singletonList(this.outboundTransformer.get());
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("outbound", this.defaultOutboundTransformer), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transformer> createResponseTransformers() throws TransportFactoryException {
        if (this.responseTransformer.get() != null) {
            return CollectionUtils.singletonList(this.responseTransformer.get());
        }
        if (this.defaultResponseTransformer != null) {
            this.logger.info((Object)("Loading default response transformer: " + this.defaultResponseTransformer));
            try {
                AtomicReference atomicReference = this.responseTransformer;
                synchronized (atomicReference) {
                    if (this.responseTransformer.get() == null) {
                        Transformer newTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultResponseTransformer, ClassUtils.NO_ARGS, this.classLoader);
                        newTransformer.setName(newTransformer.getName() + "#" + this.hashCode());
                        this.muleContext.getRegistry().registerObject(newTransformer.getName(), newTransformer);
                        this.responseTransformer.compareAndSet(null, (Object)newTransformer);
                    }
                }
                return CollectionUtils.singletonList(this.responseTransformer.get());
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("response", this.defaultResponseTransformer), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public EndpointURIBuilder createEndpointURIBuilder() throws TransportFactoryException {
        if (this.endpointUriBuilder == null) {
            this.logger.debug((Object)("Endpoint resolver not set, Loading default resolver: " + UrlEndpointURIBuilder.class.getName()));
            return new UrlEndpointURIBuilder();
        }
        this.logger.debug((Object)("Loading endpointUri resolver: " + this.endpointUriBuilder));
        try {
            return (EndpointURIBuilder)ClassUtils.instanciateClass(this.endpointUriBuilder, ClassUtils.NO_ARGS, this.classLoader);
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToLoad("EndpointURI Builder: " + this.endpointUriBuilder), (Throwable)e);
        }
    }

    @Override
    public EndpointBuilder createEndpointBuilder(String uri) throws TransportFactoryException {
        if (this.endpointBuilder == null) {
            this.logger.debug((Object)("Endpoint builder not set, Loading default builder: " + EndpointURIEndpointBuilder.class.getName()));
            return new EndpointURIEndpointBuilder(uri, this.muleContext);
        }
        this.logger.debug((Object)("Loading endpoint builder: " + this.endpointBuilder));
        try {
            return (EndpointBuilder)ClassUtils.instanciateClass(this.endpointBuilder, new Object[]{uri, this.muleContext}, this.classLoader);
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToLoad("Endpoint Builder: " + this.endpointBuilder), (Throwable)e);
        }
    }

    @Override
    public void setExceptionMappings(Properties props) {
        this.exceptionMappings = props;
    }

    @Override
    public Properties getExceptionMappings() {
        return this.exceptionMappings;
    }
}

