/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.ReceiveException;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.ConnectableLifecycleManager;

public abstract class AbstractMessageRequester
extends AbstractConnectable
implements MessageRequester {
    public AbstractMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageRequester>(this.getRequesterName(), this);
    }

    protected String getRequesterName() {
        return this.getConnector().getName() + ".requester." + System.identityHashCode(this);
    }

    public final MuleMessage request(long timeout) throws Exception {
        try {
            this.connect();
            MuleMessage result = null;
            result = this.doRequest(timeout);
            if (result != null && this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new EndpointMessageNotification(result, this.endpoint, null, 804));
            }
            return result;
        }
        catch (ReceiveException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getRequesterWorkManager();
        }
        catch (MuleException e) {
            this.handleException(e);
            return null;
        }
    }

    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    protected abstract MuleMessage doRequest(long var1) throws Exception;
}

