/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import org.apache.commons.lang.SerializationException;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleSession;
import org.mule.OptimizedRequestContext;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.session.LegacySessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.util.ClassUtils;

public abstract class AbstractMessageReceiver
extends AbstractConnectable
implements MessageReceiver {
    protected FlowConstruct flowConstruct;
    protected MessageProcessor listener;
    protected String receiverKey = null;
    private EndpointURI endpointUri;

    public AbstractMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        if (flowConstruct == null) {
            throw new IllegalArgumentException("FlowConstruct cannot be null");
        }
        this.flowConstruct = flowConstruct;
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageReceiver>(this.getReceiverKey(), this);
    }

    public final void initialise() throws InitialisationException {
        this.endpointUri = this.endpoint.getEndpointURI();
        super.initialise();
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public final MuleMessage routeMessage(MuleMessage message) throws MuleException {
        return this.routeMessage(message, this.endpoint.isSynchronous() || TransactionCoordination.getInstance().getTransaction() != null);
    }

    public final MuleMessage routeMessage(MuleMessage message, boolean synchronous) throws MuleException {
        Transaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous) throws MuleException {
        return this.routeMessage(message, trans, synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, new DefaultMuleSession(this.connector.getMuleContext()), trans, synchronous, outputStream);
    }

    public final MuleMessage routeMessage(MuleMessage message, MuleSession session, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
        if (message.getBooleanProperty("MULE_REMOTE_SYNC", false)) {
            synchronous = true;
        }
        MuleEvent muleEvent = this.createMuleEvent(message, synchronous, outputStream);
        muleEvent = OptimizedRequestContext.unsafeSetEvent(muleEvent);
        MuleEvent resultEvent = null;
        try {
            resultEvent = this.listener.process(muleEvent);
        }
        catch (FilterException e) {
            return this.handleUnacceptedFilter(muleEvent.getMessage());
        }
        return resultEvent != null ? resultEvent.getMessage() : null;
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            String messageId = message.getUniqueId();
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        }
        return message;
    }

    protected MuleEvent createMuleEvent(MuleMessage message, boolean synchronous, OutputStream outputStream) throws MuleException {
        MuleSession session;
        ResponseOutputStream ros = null;
        if (outputStream != null) {
            ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
        }
        try {
            session = this.connector.getSessionHandler().retrieveSessionInfoFromMessage(message);
        }
        catch (SerializationException e) {
            session = new LegacySessionHandler().retrieveSessionInfoFromMessage(message);
        }
        if (session != null) {
            session.setFlowConstruct(this.flowConstruct);
        } else {
            session = new DefaultMuleSession(this.flowConstruct, this.connector.getMuleContext());
        }
        return new DefaultMuleEvent(message, this.endpoint, session, synchronous, ros);
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    protected String getConnectEventId() {
        return this.connector.getName() + ".receiver (" + this.endpoint.getEndpointURI() + ")";
    }

    public void setReceiverKey(String receiverKey) {
        this.receiverKey = receiverKey;
    }

    public String getReceiverKey() {
        return this.receiverKey;
    }

    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    public void setEndpoint(InboundEndpoint endpoint) {
        super.setEndpoint(endpoint);
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getReceiverWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", receiverKey=").append(this.receiverKey);
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    public void setListener(MessageProcessor processor) {
        this.listener = processor;
    }
}

