/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.DefaultExceptionStrategy;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.InboundEndpointDecorator;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.api.transport.ReplyToHandler;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.endpoint.outbound.OutboundNotificationMessageProcessor;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.model.streaming.DelegatingInputStream;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.routing.filters.WildcardFilter;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.ConnectorLifecycleManager;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.KeyedPoolMessageDispatcherFactoryAdapter;
import org.mule.transport.KeyedPoolMessageRequesterFactoryAdapter;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnector
implements Connector,
ExceptionListener,
WorkListener {
    public static final int DEFAULT_NUM_CONCURRENT_TX_RECEIVERS = 4;
    private static final long SCHEDULER_FORCED_SHUTDOWN_TIMEOUT = 5000L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile String name;
    protected volatile ExceptionListener exceptionListener;
    protected volatile MessageDispatcherFactory dispatcherFactory;
    protected volatile MessageRequesterFactory requesterFactory;
    protected MuleMessageFactory muleMessageFactory;
    protected final GenericKeyedObjectPool dispatchers = new GenericKeyedObjectPool();
    protected final GenericKeyedObjectPool requesters = new GenericKeyedObjectPool();
    protected final Map<Object, MessageReceiver> receivers = new ConcurrentHashMap();
    protected final Map<String, FlowConstruct> flowConstructByEndpoint = new HashMap<String, FlowConstruct>();
    private volatile ThreadingProfile dispatcherThreadingProfile;
    private volatile ThreadingProfile requesterThreadingProfile;
    private volatile ThreadingProfile receiverThreadingProfile;
    protected volatile boolean createMultipleTransactedReceivers = true;
    protected volatile int numberOfConcurrentTransactedReceivers = 4;
    private RetryPolicyTemplate retryPolicyTemplate;
    private boolean dynamicNotification = false;
    private ServerNotificationHandler cachedNotificationHandler;
    private final List<String> supportedProtocols;
    private final AtomicReference receiverWorkManager = new AtomicReference();
    private final AtomicReference dispatcherWorkManager = new AtomicReference();
    private final AtomicReference requesterWorkManager = new AtomicReference();
    private ScheduledExecutorService scheduler;
    protected volatile TransportServiceDescriptor serviceDescriptor;
    protected volatile Properties serviceOverrides;
    protected volatile SessionHandler sessionHandler = new SerializeAndEncodeSessionHandler();
    protected MuleContext muleContext;
    protected ConnectorLifecycleManager lifecycleManager;
    protected AtomicBoolean connected = new AtomicBoolean(false);
    protected boolean startOnConnect = false;
    protected boolean initialStateStopped = false;
    private boolean validateConnections = true;

    public AbstractConnector(MuleContext context) {
        this.muleContext = context;
        this.lifecycleManager = new ConnectorLifecycleManager(this);
        this.setDynamicNotification(false);
        this.updateCachedNotificationHandler();
        this.supportedProtocols = new ArrayList<String>();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
        this.dispatchers.setTestOnBorrow(false);
        this.dispatchers.setTestOnReturn(true);
        this.requesters.setTestOnBorrow(false);
        this.requesters.setTestOnReturn(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set Connector name to: " + newName));
        }
        this.name = newName;
    }

    ConnectorLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<Connector>(){

                @Override
                public void onTransition(String phaseName, Connector object) throws MuleException {
                    if (AbstractConnector.this.retryPolicyTemplate == null) {
                        AbstractConnector.this.retryPolicyTemplate = (RetryPolicyTemplate)AbstractConnector.this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
                    }
                    AbstractConnector.this.initFromServiceDescriptor();
                    AbstractConnector.this.configureDispatcherPool();
                    AbstractConnector.this.setMaxRequestersActive(AbstractConnector.this.getRequesterThreadingProfile().getMaxThreadsActive());
                    AbstractConnector.this.doInitialise();
                    if (AbstractConnector.this.exceptionListener == null) {
                        AbstractConnector.this.exceptionListener = new DefaultExceptionStrategy();
                        ((DefaultExceptionStrategy)AbstractConnector.this.exceptionListener).setMuleContext(AbstractConnector.this.muleContext);
                        ((DefaultExceptionStrategy)AbstractConnector.this.exceptionListener).initialise();
                    }
                    try {
                        AbstractConnector.this.initWorkManagers();
                    }
                    catch (MuleException e) {
                        throw new LifecycleException(e, (Object)this);
                    }
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        catch (MuleException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final synchronized void start() throws MuleException {
        if (this.isInitialStateStopped()) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<Connector>)new EmptyLifecycleCallback<Connector>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<Connector>)new EmptyLifecycleCallback<Connector>());
            this.logger.info((Object)"Connector not started because 'initialStateStopped' is true");
            return;
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<Connector>(){

            @Override
            public void onTransition(String phaseName, Connector object) throws MuleException {
                if (!AbstractConnector.this.isConnected()) {
                    AbstractConnector.this.startOnConnect = true;
                    try {
                        AbstractConnector.this.connect();
                    }
                    catch (Exception e) {
                        throw new LifecycleException(e, (Object)this);
                    }
                } else {
                    AbstractConnector.this.startAfterConnect();
                }
            }
        });
    }

    protected synchronized void startAfterConnect() throws MuleException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting: " + this));
        }
        this.scheduler = this.createScheduler();
        try {
            this.initWorkManagers();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (!this.isStarted()) {
            this.doStart();
        }
        if (this.receivers != null) {
            for (MessageReceiver receiver : this.receivers.values()) {
                ArrayList<MuleException> errors = new ArrayList<MuleException>();
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                    }
                    if (receiver.getFlowConstruct().getLifecycleState().isStarted()) {
                        receiver.start();
                    }
                }
                catch (MuleException e) {
                    this.logger.error((Object)e);
                    errors.add(e);
                }
                if (errors.isEmpty()) continue;
                throw (MuleException)errors.get(0);
            }
        }
    }

    @Override
    public final synchronized void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<Connector>(){

            @Override
            public void onTransition(String phaseName, Connector object) throws MuleException {
                AbstractConnector.this.shutdownScheduler();
                AbstractConnector.this.doStop();
                if (AbstractConnector.this.receivers != null) {
                    for (MessageReceiver receiver : AbstractConnector.this.receivers.values()) {
                        if (AbstractConnector.this.logger.isDebugEnabled()) {
                            AbstractConnector.this.logger.debug((Object)("Stopping receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                        }
                        receiver.stop();
                    }
                }
                if (AbstractConnector.this.isConnected()) {
                    try {
                        AbstractConnector.this.disconnect();
                    }
                    catch (Exception e) {
                        AbstractConnector.this.logger.error((Object)("Failed to disconnect: " + e.getMessage()), (Throwable)e);
                    }
                }
                AbstractConnector.this.disposeWorkManagers();
                AbstractConnector.this.clearDispatchers();
                AbstractConnector.this.clearRequesters();
                AbstractConnector.this.scheduler = null;
            }
        });
    }

    @Override
    public final synchronized void dispose() {
        try {
            if (this.lifecycleManager.getState().isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<Connector>(){

                @Override
                public void onTransition(String phaseName, Connector object) throws MuleException {
                    AbstractConnector.this.doDispose();
                    AbstractConnector.this.disposeReceivers();
                }
            });
        }
        catch (MuleException e) {
            this.logger.warn((Object)("Failed to dispose connector: " + this.name), (Throwable)e);
        }
    }

    @Override
    public final boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isInitialised() {
        return this.lifecycleManager.getState().isInitialised();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    protected void configureDispatcherPool() {
        int maxDispatchersActive = this.getDispatcherThreadingProfile().getMaxThreadsActive();
        if (4 == this.getDispatcherThreadingProfile().getPoolExhaustedAction()) {
            ++maxDispatchersActive;
        }
        this.setMaxDispatchersActive(maxDispatchersActive);
    }

    @Override
    public MuleMessageFactory createMuleMessageFactory() throws CreateException {
        try {
            return this.serviceDescriptor.createMuleMessageFactory();
        }
        catch (TransportServiceException tse) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessageFactory"), tse, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownScheduler() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS)) {
                    List outstanding = this.scheduler.shutdownNow();
                    if (!this.scheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                        this.logger.warn((Object)MessageFormat.format("Pool {0} did not terminate in time; {1} work items were cancelled.", this.name, outstanding.isEmpty() ? "No" : Integer.toString(outstanding.size())));
                    } else if (!outstanding.isEmpty()) {
                        this.logger.warn((Object)MessageFormat.format("Pool {0} terminated; {1} work items were cancelled.", this.name, Integer.toString(outstanding.size())));
                    }
                }
            }
            catch (InterruptedException ie) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.scheduler = null;
            }
        }
    }

    protected void initWorkManagers() throws MuleException {
        WorkManager newWorkManager;
        if (this.receiverWorkManager.get() == null && this.receiverWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getReceiverThreadingProfile().createWorkManager(this.getName() + ".receiver", this.muleContext.getConfiguration().getShutdownTimeout())))) {
            newWorkManager.start();
        }
        if (this.dispatcherWorkManager.get() == null) {
            WorkManager newWorkManager2;
            ThreadingProfile dispatcherThreadingProfile = this.getDispatcherThreadingProfile();
            if (dispatcherThreadingProfile.getMuleContext() == null) {
                dispatcherThreadingProfile.setMuleContext(this.muleContext);
            }
            if (this.dispatcherWorkManager.compareAndSet(null, (Object)(newWorkManager2 = dispatcherThreadingProfile.createWorkManager(this.getName() + ".dispatcher", this.muleContext.getConfiguration().getShutdownTimeout())))) {
                newWorkManager2.start();
            }
        }
        if (this.requesterWorkManager.get() == null && this.requesterWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getRequesterThreadingProfile().createWorkManager(this.getName() + ".requester", this.muleContext.getConfiguration().getShutdownTimeout())))) {
            newWorkManager.start();
        }
    }

    protected void disposeWorkManagers() {
        this.logger.debug((Object)"Disposing dispatcher work manager");
        WorkManager workManager = (WorkManager)this.dispatcherWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.dispatcherWorkManager.set(null);
        this.logger.debug((Object)"Disposing requester work manager");
        workManager = (WorkManager)this.requesterWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.requesterWorkManager.set(null);
        this.logger.debug((Object)"Disposing receiver work manager");
        workManager = (WorkManager)this.receiverWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.receiverWorkManager.set(null);
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            this.logger.debug((Object)"Disposing Receivers");
            for (MessageReceiver receiver : this.receivers.values()) {
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + receiver), e);
                }
            }
            this.receivers.clear();
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Clearing Dispatcher pool");
            GenericKeyedObjectPool genericKeyedObjectPool = this.dispatchers;
            synchronized (genericKeyedObjectPool) {
                this.dispatchers.clear();
            }
            this.logger.debug((Object)"Dispatcher pool cleared");
        }
    }

    protected void clearRequesters() {
        if (this.requesters != null) {
            this.logger.debug((Object)"Clearing Requester pool");
            this.requesters.clear();
            this.logger.debug((Object)"Requester pool cleared");
        }
    }

    @Override
    public boolean isDisposed() {
        return this.lifecycleManager.getState().isDisposed();
    }

    @Override
    public void handleException(Exception exception) {
        this.handleException(exception, null);
    }

    public void handleException(Exception exception, Connectable failed) {
        if (exception instanceof InvocationTargetException) {
            Throwable target = exception.getCause();
            Exception exception2 = exception = target instanceof Exception ? (Exception)target : new Exception(target);
        }
        if (this.isConnected() && exception instanceof ConnectException && !(this.retryPolicyTemplate instanceof NoRetryPolicyTemplate)) {
            this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
            try {
                try {
                    this.disconnect();
                }
                catch (Exception de) {
                    this.logger.error((Object)de);
                }
                if (this.exceptionListener == null) {
                    throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNoExceptionListener(this.getName()), (Throwable)exception);
                }
                this.exceptionListener.exceptionThrown(exception);
                HashMap<Object, Object> info = new HashMap<Object, Object>();
                if (failed instanceof MessageReceiver) {
                    info.put("failedReceiver", ((MessageReceiver)failed).getReceiverKey());
                } else if (failed instanceof MessageDispatcher) {
                    info.put("failedDispatcher", ((MessageDispatcher)failed).getEndpoint());
                } else if (failed instanceof MessageRequester) {
                    info.put("failedRequester", ((MessageRequester)failed).getEndpoint());
                }
                this.retryPolicyTemplate.setMetaInfo(info);
                this.connect();
            }
            catch (Exception e) {
                if (this.exceptionListener == null) {
                    throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNoExceptionListener(this.getName()), (Throwable)e);
                }
                this.exceptionListener.exceptionThrown(e);
            }
        } else if (this.exceptionListener != null) {
            this.exceptionListener.exceptionThrown(exception);
        } else {
            throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNoExceptionListener(this.getName()), (Throwable)exception);
        }
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    @Override
    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    @Override
    public MessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    @Override
    public void setDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        Object poolFactory = dispatcherFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)dispatcherFactory : new KeyedPoolMessageDispatcherFactoryAdapter(dispatcherFactory);
        this.dispatchers.setFactory(poolFactory);
        this.dispatcherFactory = dispatcherFactory;
    }

    @Override
    public MessageRequesterFactory getRequesterFactory() {
        return this.requesterFactory;
    }

    @Override
    public void setRequesterFactory(MessageRequesterFactory requesterFactory) {
        Object poolFactory = requesterFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)requesterFactory : new KeyedPoolMessageRequesterFactoryAdapter(requesterFactory);
        this.requesters.setFactory(poolFactory);
        this.requesterFactory = requesterFactory;
    }

    public MuleMessageFactory getMuleMessageFactory() throws CreateException {
        if (this.muleMessageFactory == null) {
            this.muleMessageFactory = this.createMuleMessageFactory();
        }
        return this.muleMessageFactory;
    }

    public boolean isInitialStateStopped() {
        return this.initialStateStopped;
    }

    public void setInitialStateStopped(boolean initialStateStopped) {
        this.initialStateStopped = initialStateStopped;
    }

    public int getMaxDispatchersActive() {
        return this.dispatchers.getMaxActive();
    }

    public int getMaxTotalDispatchers() {
        return this.dispatchers.getMaxTotal();
    }

    public void setMaxDispatchersActive(int maxActive) {
        this.dispatchers.setMaxActive(maxActive);
        this.dispatchers.setMaxIdle(maxActive);
        this.dispatchers.setMaxTotal(20 * maxActive);
    }

    private MessageDispatcher getDispatcher(OutboundEndpoint endpoint) throws MuleException {
        if (!this.isStarted()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageDispatcher dispatcher = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a dispatcher for endpoint: " + endpoint.getEndpointURI()));
            }
            dispatcher = (MessageDispatcher)this.dispatchers.borrowObject((Object)endpoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
            }
            MessageDispatcher messageDispatcher = dispatcher;
            return messageDispatcher;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    private void returnDispatcher(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        if (endpoint != null && dispatcher != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
            }
            try {
                this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
            }
        }
    }

    public int getMaxRequestersActive() {
        return this.requesters.getMaxActive();
    }

    public void setMaxRequestersActive(int maxActive) {
        this.requesters.setMaxActive(maxActive);
        this.requesters.setMaxIdle(maxActive);
        this.requesters.setMaxTotal(20 * maxActive);
    }

    private MessageRequester getRequester(InboundEndpoint endpoint) throws MuleException {
        if (!this.isStarted()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageRequester requester = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a requester for endpoint: " + endpoint.getEndpointURI()));
            }
            requester = (MessageRequester)this.requesters.borrowObject((Object)endpoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
            }
            MessageRequester messageRequester = requester;
            return messageRequester;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed requester: " + ObjectUtils.toString((Object)requester, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    private void returnRequester(InboundEndpoint endpoint, MessageRequester requester) {
        if (endpoint != null && requester != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
            }
            try {
                this.requesters.returnObject((Object)endpoint, (Object)requester);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
            }
        }
    }

    @Override
    public void registerListener(InboundEndpoint endpoint, MessageProcessor messageProcessorChain, FlowConstruct flowConstruct) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (messageProcessorChain == null) {
            throw new IllegalArgumentException("The messageProcessorChain cannot be null when registering a listener");
        }
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(CoreMessages.endpointIsNullForListener(), this);
        }
        this.logger.info((Object)("Registering listener: " + flowConstruct.getName() + " on endpointUri: " + endpointUri.toString()));
        if (this.getReceiver(flowConstruct, endpoint) != null) {
            throw new ConnectorException(CoreMessages.listenerAlreadyRegistered(endpointUri), this);
        }
        MessageReceiver receiver = this.createReceiver(flowConstruct, endpoint);
        receiver.setListener(messageProcessorChain);
        Object receiverKey = this.getReceiverKey(flowConstruct, endpoint);
        receiver.setReceiverKey(receiverKey.toString());
        receiver.initialise();
        this.receivers.put(receiverKey, receiver);
        this.flowConstructByEndpoint.put(endpoint.getName(), flowConstruct);
        if (endpoint instanceof InboundEndpointDecorator) {
            ((InboundEndpointDecorator)((Object)endpoint)).onListenerAdded(flowConstruct);
        }
        if (this.isConnected()) {
            receiver.connect();
        }
        if (this.isStarted()) {
            receiver.start();
        }
    }

    protected Object getReceiverKey(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    @Override
    public final void unregisterListener(InboundEndpoint endpoint) throws Exception {
        MessageReceiver receiver;
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        FlowConstruct flowConstruct = this.flowConstructByEndpoint.remove(endpoint.getName());
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Removing listener on endpointUri: " + endpointUri));
        }
        if (this.receivers != null && !this.receivers.isEmpty() && (receiver = this.receivers.remove(this.getReceiverKey(flowConstruct, endpoint))) != null) {
            if (this.isConnected()) {
                receiver.disconnect();
            }
            if (this.isStarted()) {
                receiver.stop();
            }
            this.destroyReceiver(receiver, endpoint);
            this.doUnregisterListener(flowConstruct, endpoint, receiver);
        }
    }

    protected void doUnregisterListener(FlowConstruct flowConstruct, InboundEndpoint endpoint, MessageReceiver receiver) {
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null && this.muleContext != null) {
            this.dispatcherThreadingProfile = this.muleContext.getDefaultMessageDispatcherThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getRequesterThreadingProfile() {
        if (this.requesterThreadingProfile == null && this.muleContext != null) {
            this.requesterThreadingProfile = this.muleContext.getDefaultMessageRequesterThreadingProfile();
        }
        return this.requesterThreadingProfile;
    }

    public void setRequesterThreadingProfile(ThreadingProfile requesterThreadingProfile) {
        this.requesterThreadingProfile = requesterThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null && this.muleContext != null) {
            this.receiverThreadingProfile = this.muleContext.getDefaultMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public void destroyReceiver(MessageReceiver receiver, ImmutableEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    public List<Transformer> getDefaultInboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultInboundTransformers(this.serviceDescriptor);
    }

    public List<Transformer> getDefaultResponseTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultResponseTransformers(this.serviceDescriptor);
    }

    public List<Transformer> getDefaultOutboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultOutboundTransformers(this.serviceDescriptor);
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.getDefaultResponseTransformers(), this.muleContext);
    }

    public void fireNotification(ServerNotification notification) {
        this.cachedNotificationHandler.fireNotification(notification);
    }

    @Override
    public boolean isResponseEnabled() {
        return false;
    }

    @Override
    public boolean isSyncEnabled(String protocol) {
        return false;
    }

    public MessageReceiver getReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        if (this.receivers != null) {
            Object key = this.getReceiverKey(flowConstruct, endpoint);
            if (key != null) {
                return this.receivers.get(key);
            }
            throw new RuntimeException("getReceiverKey() returned a null key");
        }
        throw new RuntimeException("Connector has not been initialized.");
    }

    public Map<Object, MessageReceiver> getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public MessageReceiver lookupReceiver(String key) {
        if (key != null) {
            return this.receivers.get(key);
        }
        throw new IllegalArgumentException("Receiver key must not be null");
    }

    public MessageReceiver[] getReceivers(String wildcardExpression) {
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        ArrayList<MessageReceiver> found = new ArrayList<MessageReceiver>();
        for (Map.Entry<Object, MessageReceiver> e : this.receivers.entrySet()) {
            if (!filter.accept(e.getKey())) continue;
            found.add(e.getValue());
        }
        return CollectionUtils.toArrayOfComponentType(found, MessageReceiver.class);
    }

    @Override
    public void connect() throws Exception {
        if (this.lifecycleManager.getState().isDisposed()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (this.isConnected()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting: " + this));
        }
        RetryCallback callback = new RetryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork(RetryContext context) throws Exception {
                block15: {
                    if (AbstractConnector.this.validateConnections && !AbstractConnector.this.validateConnection(context).isOk()) {
                        throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect to resource"), context.getLastFailure(), null);
                    }
                    AbstractConnector.this.doConnect();
                    Map<Object, Object> info = context.getMetaInfo();
                    if (info.get("failedReceiver") != null) {
                        String receiverKey = (String)info.get("failedReceiver");
                        MessageReceiver receiver = AbstractConnector.this.receivers.get(receiverKey);
                        if (AbstractConnector.this.validateConnections && !receiver.validateConnection(context).isOk()) {
                            throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect receiver to resource"), context.getLastFailure(), receiver);
                        }
                    } else {
                        if (info.get("failedDispatcher") != null) {
                            OutboundEndpoint endpoint = (OutboundEndpoint)info.get("failedDispatcher");
                            MessageDispatcher dispatcher = (MessageDispatcher)AbstractConnector.this.dispatchers.borrowObject((Object)endpoint);
                            try {
                                if (AbstractConnector.this.validateConnections && !dispatcher.validateConnection(context).isOk()) {
                                    throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect dispatcher to resource"), context.getLastFailure(), null);
                                }
                                break block15;
                            }
                            finally {
                                AbstractConnector.this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                            }
                        }
                        if (info.get("failedRequester") != null) {
                            InboundEndpoint endpoint = (InboundEndpoint)info.get("failedRequester");
                            MessageRequester requester = (MessageRequester)AbstractConnector.this.requesters.borrowObject((Object)endpoint);
                            try {
                                if (AbstractConnector.this.validateConnections && !requester.validateConnection(context).isOk()) {
                                    throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect requester to resource"), context.getLastFailure(), null);
                                }
                            }
                            finally {
                                AbstractConnector.this.requesters.returnObject((Object)endpoint, (Object)requester);
                            }
                        }
                    }
                }
                AbstractConnector.this.setConnected(true);
                AbstractConnector.this.logger.info((Object)("Connected: " + this.getWorkDescription()));
                if (AbstractConnector.this.startOnConnect) {
                    AbstractConnector.this.startAfterConnect();
                }
            }

            public String getWorkDescription() {
                return AbstractConnector.this.getConnectionDescription();
            }
        };
        this.retryPolicyTemplate.execute(callback, this.muleContext.getWorkManager());
    }

    @Override
    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws Exception {
        this.startOnConnect = this.isStarted();
        try {
            if (this.receivers != null) {
                for (MessageReceiver receiver : this.receivers.values()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Disconnecting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                    }
                    receiver.disconnect();
                }
            }
            this.doDisconnect();
        }
        finally {
            if (this.receivers != null) {
                for (MessageReceiver receiver : this.receivers.values()) {
                    if (!(receiver instanceof AbstractMessageReceiver) || !((AbstractMessageReceiver)receiver).isStarted()) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Stopping receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                    }
                    receiver.stop();
                }
            }
        }
        this.connected.set(false);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
        }
        this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
    }

    @Override
    public String getConnectionDescription() {
        return this.toString();
    }

    @Override
    public final boolean isConnected() {
        return this.connected.get();
    }

    public final void setConnected(boolean flag) {
        this.connected.set(flag);
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected String getConnectEventId() {
        return this.getName();
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public int getNumberOfConcurrentTransactedReceivers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public void setNumberOfConcurrentTransactedReceivers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public void setDynamicNotification(boolean dynamic) {
        this.dynamicNotification = dynamic;
    }

    protected void updateCachedNotificationHandler() {
        if (null != this.muleContext) {
            this.cachedNotificationHandler = this.dynamicNotification ? this.muleContext.getNotificationManager() : new OptimisedNotificationHandler(this.muleContext.getNotificationManager(), EndpointMessageNotification.class);
        }
    }

    public boolean isEnableMessageEvents() {
        return this.cachedNotificationHandler.isNotificationEnabled(EndpointMessageNotification.class);
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithoutPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public void registerSupportedMetaProtocol(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase() + ":" + this.getProtocol().toLowerCase());
    }

    protected void registerSupportedProtocolWithoutPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    @Override
    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        for (String s : supportedProtocols) {
            this.registerSupportedProtocol(s);
        }
    }

    protected WorkManager getReceiverWorkManager() throws MuleException {
        return (WorkManager)this.receiverWorkManager.get();
    }

    protected WorkManager getDispatcherWorkManager() throws MuleException {
        return (WorkManager)this.dispatcherWorkManager.get();
    }

    protected WorkManager getRequesterWorkManager() throws MuleException {
        return (WorkManager)this.requesterWorkManager.get();
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    protected ScheduledExecutorService createScheduler() {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.getName() + ".scheduler", this.getClass().getClassLoader());
        ScheduledThreadPoolExecutor newExecutor = new ScheduledThreadPoolExecutor(4, (ThreadFactory)threadFactory);
        newExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        newExecutor.setKeepAliveTime(this.getReceiverThreadingProfile().getThreadTTL(), TimeUnit.MILLISECONDS);
        newExecutor.allowCoreThreadTimeOut(true);
        return newExecutor;
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.connectorCausedError(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    protected void setupDispatchReturn(final OutboundEndpoint endpoint, final MessageDispatcher dispatcher, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnDispatcher(endpoint, dispatcher);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    @Override
    public MuleMessage request(String uri, long timeout) throws Exception {
        return this.request(this.getMuleContext().getRegistry().lookupEndpointFactory().getInboundEndpoint(uri), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleMessage request(InboundEndpoint endpoint, long timeout) throws Exception {
        MessageRequester requester = null;
        MuleMessage result = null;
        try {
            requester = this.getRequester(endpoint);
            MuleMessage muleMessage = result = requester.request(timeout);
            this.setupRequestReturn(endpoint, requester, result);
            return muleMessage;
        }
        catch (Throwable throwable) {
            this.setupRequestReturn(endpoint, requester, result);
            throw throwable;
        }
    }

    protected void setupRequestReturn(final InboundEndpoint endpoint, final MessageRequester requester, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnRequester(endpoint, requester);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnRequester(endpoint, requester);
        }
    }

    public void initialiseFromUrl(EndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.supportsProtocol(endpointUri.getFullScheme())) {
            throw new InitialisationException(CoreMessages.schemeNotCompatibleWithConnector(endpointUri.getFullScheme(), this.getClass()), (Initialisable)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUser());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        BeanUtils.populateWithoutFail(this, props, true);
        this.setName(new ObjectNameHelper(this.muleContext).getConnectorName(this));
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            MessageRequesterFactory rf;
            MessageDispatcherFactory df;
            this.serviceDescriptor = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(this.getProtocol()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading DispatcherFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((df = this.serviceDescriptor.createDispatcherFactory()) != null) {
                this.setDispatcherFactory(df);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support outbound endpoints: "));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading RequesterFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((rf = this.serviceDescriptor.createRequesterFactory()) != null) {
                this.setRequesterFactory(rf);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support requests: "));
            }
            this.sessionHandler = this.serviceDescriptor.createSessionHandler();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected TransportServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    protected MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, flowConstruct, endpoint);
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }

    @Override
    public OutputStream getOutputStream(OutboundEndpoint endpoint, MuleMessage message) throws MuleException {
        throw new UnsupportedOperationException(CoreMessages.streamingNotSupported(this.getProtocol()).toString());
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(120);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{name=").append(this.name);
        sb.append(", lifecycle=").append(this.lifecycleManager == null ? "not in lifecycle" : this.lifecycleManager.getCurrentPhase());
        sb.append(", this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", numberOfConcurrentTransactedReceivers=").append(this.numberOfConcurrentTransactedReceivers);
        sb.append(", createMultipleTransactedReceivers=").append(this.createMultipleTransactedReceivers);
        sb.append(", connected=").append(this.connected);
        sb.append(", supportedProtocols=").append(this.supportedProtocols);
        sb.append(", serviceOverrides=").append(this.serviceOverrides);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public void setValidateConnections(boolean validateConnections) {
        this.validateConnections = validateConnections;
    }

    public void setDispatcherPoolWhenExhaustedAction(byte whenExhaustedAction) {
        this.dispatchers.setWhenExhaustedAction(whenExhaustedAction);
    }

    public void setDispatcherPoolMaxWait(int maxWait) {
        this.dispatchers.setMaxWait((long)maxWait);
    }

    public void setRequesterPoolWhenExhaustedAction(byte whenExhaustedAction) {
        this.requesters.setWhenExhaustedAction(whenExhaustedAction);
    }

    public void setRequesterPoolMaxWait(int maxWait) {
        this.requesters.setMaxWait((long)maxWait);
    }

    public MessageProcessor createDispatcherMessageProcessor(OutboundEndpoint endpoint) throws MuleException {
        InterceptingChainMessageProcessorBuilder builder = new InterceptingChainMessageProcessorBuilder();
        builder.chain(new AsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return AbstractConnector.this.getDispatcherWorkManager();
            }
        }, this.getDispatcherThreadingProfile().isDoThreading(), this));
        builder.chain(new MessageProcessor(){
            private MessageProcessor notificationMessageProcessor;

            public MuleEvent process(MuleEvent event) throws MuleException {
                OutboundEndpoint endpoint = (OutboundEndpoint)event.getEndpoint();
                MessageDispatcher dispatcher = null;
                try {
                    dispatcher = AbstractConnector.this.getDispatcher(endpoint);
                    MuleEvent result = dispatcher.process(event);
                    if (this.notificationMessageProcessor == null) {
                        this.notificationMessageProcessor = new OutboundNotificationMessageProcessor(endpoint);
                    }
                    this.notificationMessageProcessor.process(event);
                    MuleEvent muleEvent = result;
                    return muleEvent;
                }
                catch (DispatchException dex) {
                    throw dex;
                }
                catch (MuleException ex) {
                    throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
                }
                finally {
                    AbstractConnector.this.returnDispatcher(endpoint, dispatcher);
                }
            }
        });
        return builder.build();
    }
}

