/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

public class TransactionTemplate {
    private static final Log logger = LogFactory.getLog(TransactionTemplate.class);
    private final TransactionConfig config;
    private final ExceptionListener exceptionListener;
    private final MuleContext context;

    public TransactionTemplate(TransactionConfig config, ExceptionListener listener, MuleContext context) {
        this.config = config;
        this.exceptionListener = listener;
        this.context = context;
    }

    public Object execute(TransactionCallback callback) throws Exception {
        TransactionFactory tmFactory;
        if (this.config == null) {
            return callback.doInTransaction();
        }
        Transaction joinedExternal = null;
        int action = this.config != null ? (int)this.config.getAction() : 5;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx == null && this.context != null && this.config != null && this.config.isInteractWithExternal() && (tmFactory = this.config.getFactory()) instanceof ExternalTransactionAwareTransactionFactory) {
            ExternalTransactionAwareTransactionFactory extmFactory = (ExternalTransactionAwareTransactionFactory)tmFactory;
            joinedExternal = tx = extmFactory.joinExternalTransaction(this.context);
        }
        Transaction suspendedXATx = null;
        if (action == 5 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Never"));
        }
        if ((action == 0 || action == 1) && tx != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(action + ", " + "current TX: " + tx));
            }
            if (tx.isXA()) {
                suspendedXATx = tx;
                this.suspendXATransaction(suspendedXATx);
            } else {
                this.resolveTransaction(tx);
            }
            tx = null;
        } else if (action == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        if (action == 1 || action == 2 && tx == null) {
            logger.debug((Object)"Beginning transaction");
            tx = this.config.getFactory().beginTransaction(this.context);
            logger.debug((Object)("Transaction successfully started: " + tx));
        } else {
            tx = null;
        }
        try {
            Object result = callback.doInTransaction();
            if (tx != null) {
                tx = TransactionCoordination.getInstance().getTransaction();
            }
            if (tx != null) {
                this.resolveTransaction(tx);
            }
            if (suspendedXATx != null) {
                this.resumeXATransaction(suspendedXATx);
                tx = suspendedXATx;
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            tx = TransactionCoordination.getInstance().getTransaction();
            if (this.isExceptionHandledAtThisLevel(tx)) {
                logger.info((Object)("Exception Caught in Transaction template.  Handing off to exception handler: " + this.exceptionListener));
                this.exceptionListener.exceptionThrown(e);
            } else {
                logger.info((Object)"Exception Caught in Transaction template without any exception listeners defined, exception is rethrown.");
                if (tx != null) {
                    tx.setRollbackOnly();
                }
            }
            if (tx != null) {
                if (tx.isRollbackOnly()) {
                    logger.debug((Object)"Exception caught: rollback transaction", (Throwable)e);
                }
                this.resolveTransaction(tx);
            }
            if (suspendedXATx != null) {
                this.resumeXATransaction(suspendedXATx);
                Object var7_10 = null;
                return var7_10;
            }
            if (this.isExceptionHandledAtThisLevel(tx)) {
                Object var7_11 = null;
                return var7_11;
            }
            throw e;
        }
        catch (Error e) {
            if (tx != null) {
                logger.info((Object)("Error caught, rolling back TX " + tx), (Throwable)e);
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (joinedExternal != null) {
                TransactionCoordination.getInstance().unbindTransaction(joinedExternal);
            }
        }
    }

    private boolean isExceptionHandledAtThisLevel(Transaction tx) {
        return this.exceptionListener != null && tx != null;
    }

    protected void resolveTransaction(Transaction tx) throws TransactionException {
        if (tx.isRollbackOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction has been marked rollbackOnly, rolling it back: " + tx));
            }
            tx.rollback();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Committing transaction " + tx));
            }
            tx.commit();
        }
    }

    protected void suspendXATransaction(Transaction tx) throws TransactionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Suspending " + tx));
        }
        tx.suspend();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Successfully suspended " + tx));
            logger.debug((Object)("Unbinding the following TX from the current context: " + tx));
        }
        TransactionCoordination.getInstance().unbindTransaction(tx);
    }

    protected void resumeXATransaction(Transaction tx) throws TransactionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Re-binding and Resuming " + tx));
        }
        TransactionCoordination.getInstance().bindTransaction(tx);
        tx.resume();
    }
}

