/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Status;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionStatusException;

public abstract class AbstractSingleResourceTransaction
extends AbstractTransaction {
    protected static Map<Integer, String> txStatusMappings;
    protected volatile Object key;
    protected volatile Object resource;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean committed = new AtomicBoolean(false);
    protected final AtomicBoolean rolledBack = new AtomicBoolean(false);
    protected final AtomicBoolean rollbackOnly = new AtomicBoolean(false);

    protected AbstractSingleResourceTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    public void begin() throws TransactionException {
        super.begin();
        this.started.compareAndSet(false, true);
    }

    public void commit() throws TransactionException {
        super.commit();
        this.committed.compareAndSet(false, true);
    }

    public void rollback() throws TransactionException {
        super.rollback();
        this.rolledBack.compareAndSet(false, true);
    }

    public int getStatus() throws TransactionStatusException {
        if (this.rolledBack.get()) {
            return 4;
        }
        if (this.committed.get()) {
            return 3;
        }
        if (this.rollbackOnly.get()) {
            return 1;
        }
        if (this.started.get()) {
            return 0;
        }
        return 6;
    }

    public Object getResource(Object key) {
        return key != null && this.key == key ? this.resource : null;
    }

    public boolean hasResource(Object key) {
        return key != null && this.key == key;
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindToNullKey());
        }
        if (resource == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindNullResource());
        }
        if (this.key != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionSingleResourceOnly());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding " + resource + " to " + key));
        }
        this.key = key;
        this.resource = resource;
    }

    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    public String toString() {
        int status;
        try {
            status = this.getStatus();
        }
        catch (TransactionException e) {
            status = -1;
        }
        String statusName = txStatusMappings.get(status);
        if (statusName == null) {
            statusName = "*undefined*";
        }
        return this.getClass().getName() + '@' + this.id + "[status=" + statusName + ", key=" + this.key + ", resource=" + this.resource + "]";
    }

    static {
        Field[] fields;
        txStatusMappings = new HashMap<Integer, String>(10);
        for (Field field : fields = Status.class.getFields()) {
            try {
                txStatusMappings.put(field.getInt(Status.class), field.getName());
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        txStatusMappings = Collections.unmodifiableMap(txStatusMappings);
    }
}

