/*
 * Decompiled with CFR 0.152.
 */
package org.mule.source;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.CoreMessages;

public class StartablePatternAwareCompositeMessageSource
implements CompositeMessageSource,
Startable,
Stoppable,
FlowConstructAware {
    protected static final Log log = LogFactory.getLog(StartablePatternAwareCompositeMessageSource.class);
    protected MessageProcessor listener;
    protected AtomicBoolean started = new AtomicBoolean(false);
    private MessageProcessor internalListener = new InternalMessageProcessor();
    private List<MessageSource> sources = Collections.synchronizedList(new ArrayList());
    private AtomicBoolean starting = new AtomicBoolean(false);
    private FlowConstruct flowConstruct;

    public void addSource(MessageSource source) throws MuleException {
        this.sources.add(source);
        source.setListener(this.internalListener);
        if (this.started.get()) {
            if (source instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)source)).setFlowConstruct(this.flowConstruct);
            }
            if (source instanceof Startable) {
                ((Startable)((Object)source)).start();
            }
        }
    }

    public void removeSource(MessageSource source) throws MuleException {
        if (this.started.get() && source instanceof Stoppable) {
            ((Stoppable)((Object)source)).stop();
        }
        this.sources.remove(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MuleException {
        if (this.listener == null) {
            throw new LifecycleException(CoreMessages.objectIsNull("listener"), (Object)this);
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.starting.set(true);
            for (MessageSource source : this.sources) {
                if (source instanceof FlowConstructAware) {
                    ((FlowConstructAware)((Object)source)).setFlowConstruct(this.flowConstruct);
                }
                if (!(source instanceof Startable)) continue;
                ((Startable)((Object)source)).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MuleException {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (!(source instanceof Stoppable)) continue;
                ((Stoppable)((Object)source)).stop();
            }
            this.started.set(false);
        }
    }

    public void setListener(MessageProcessor listener) {
        this.listener = listener;
    }

    public void setFlowConstruct(FlowConstruct pattern) {
        this.flowConstruct = pattern;
    }

    public String toString() {
        return "StartableMessageSourceAgregator [listener=" + this.listener + ", sources=" + this.sources + ", started=" + this.started + "]";
    }

    private class InternalMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            if (StartablePatternAwareCompositeMessageSource.this.started.get() || StartablePatternAwareCompositeMessageSource.this.starting.get()) {
                return StartablePatternAwareCompositeMessageSource.this.listener.process(event);
            }
            log.warn((Object)("Message " + event + " was recieved from MessageSource, but message source " + this + " is stopped.  Message will be discarded."));
            return null;
        }
    }
}

