/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.model.SessionException;
import org.mule.config.i18n.MessageFactory;
import org.mule.session.SerializeOnlySessionHandler;
import org.mule.util.Base64;

public class SerializeAndEncodeSessionHandler
extends SerializeOnlySessionHandler {
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        byte[] serializedSession;
        MuleSession session = null;
        String serializedEncodedSession = (String)message.getProperty("MULE_SESSION");
        message.removeProperty("MULE_SESSION");
        if (serializedEncodedSession != null && (serializedSession = Base64.decode(serializedEncodedSession)) != null) {
            session = (MuleSession)SerializationUtils.deserialize((byte[])serializedSession);
        }
        return session;
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        String serializedEncodedSession;
        byte[] serializedSession = SerializationUtils.serialize((Serializable)this.removeNonSerializableProperties(session));
        try {
            serializedEncodedSession = Base64.encodeBytes(serializedSession, 8);
        }
        catch (IOException e) {
            throw new SessionException(MessageFactory.createStaticMessage("Unable to serialize MuleSession"), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized and base64-encoded Session header to message: " + serializedEncodedSession));
        }
        message.setProperty("MULE_SESSION", serializedEncodedSession);
    }
}

