/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.processor;

import java.beans.ExceptionListener;
import org.apache.commons.lang.BooleanUtils;
import org.mule.AbstractExceptionListener;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.response.AsyncReplyReceiveMessageProcessor;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;

public class ServiceInternalMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected Service service;
    protected MessageProcessor receiveAsyncReplyMessageProcessor;

    public ServiceInternalMessageProcessor(Service service) {
        this.service = service;
        this.receiveAsyncReplyMessageProcessor = new AsyncReplyReceiveMessageProcessor(service.getResponseRouter());
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent resultEvent;
        block7: {
            ExceptionListener exceptionListener = this.service.getExceptionListener();
            resultEvent = null;
            try {
                Object replyTo = event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), (InboundEndpoint)event.getEndpoint());
                event.getMessage().setReplyTo(null);
                resultEvent = this.service.getComponent().process(event);
                resultEvent = this.processNext(resultEvent);
                resultEvent = this.receiveAsyncReplyMessageProcessor.process(resultEvent);
                if (!event.isSynchronous() || resultEvent != null && !BooleanUtils.toBoolean((String)((String)resultEvent.getProperty("MULE_REPLYTO_STOP")))) {
                    this.processReplyTo(event, resultEvent, replyToHandler, replyTo);
                }
            }
            catch (Exception e) {
                ExceptionPayload exceptionPayload;
                event.getSession().setValid(false);
                if (e instanceof MessagingException) {
                    exceptionListener.exceptionThrown(e);
                } else {
                    exceptionListener.exceptionThrown(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), event.getMessage(), e));
                }
                if (!event.isSynchronous()) break block7;
                if (resultEvent == null) {
                    resultEvent = exceptionListener != null && exceptionListener instanceof AbstractExceptionListener && ((AbstractExceptionListener)exceptionListener).getReturnMessage() != null ? new DefaultMuleEvent(((AbstractExceptionListener)exceptionListener).getReturnMessage(), event) : new DefaultMuleEvent(new DefaultMuleMessage((Object)NullPayload.getInstance(), RequestContext.getEvent().getMessage(), event.getMuleContext()), event);
                }
                if ((exceptionPayload = event.getMessage().getExceptionPayload()) == null) {
                    exceptionPayload = new DefaultExceptionPayload(e);
                }
                resultEvent.getMessage().setExceptionPayload(exceptionPayload);
            }
        }
        return resultEvent;
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, InboundEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    protected void processReplyTo(MuleEvent event, MuleEvent result, ReplyToHandler replyToHandler, Object replyTo) throws MuleException {
        String requestor;
        if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
            replyToHandler.processReplyTo(event, result.getMessage(), replyTo);
        }
    }
}

