/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.EncryptionStrategy;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleSecurityManager
implements SecurityManager {
    protected static final Log logger = LogFactory.getLog(MuleSecurityManager.class);
    private Map<String, SecurityProvider> providers = new ConcurrentHashMap();
    private Map<String, EncryptionStrategy> cryptoStrategies = new ConcurrentHashMap();

    @Override
    public void initialise() throws InitialisationException {
        LinkedList<SecurityProvider> all = new LinkedList<SecurityProvider>(this.providers.values());
        all.addAll(this.cryptoStrategies.values());
        LifecycleTransitionResult.initialiseAll(all.iterator());
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws SecurityException, SecurityProviderNotFoundException {
        Iterator<SecurityProvider> iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            Authentication result;
            block4: {
                SecurityProvider provider = iter.next();
                if (!provider.supports(toTest)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
                }
                result = null;
                try {
                    result = provider.authenticate(authentication);
                }
                catch (Exception e) {
                    if (iter.hasNext()) break block4;
                    throw new UnauthorisedException(CoreMessages.authorizationAttemptFailed(), (Throwable)e);
                }
            }
            if (result == null) continue;
            return result;
        }
        throw new SecurityProviderNotFoundException(toTest.getName());
    }

    @Override
    public void addProvider(SecurityProvider provider) {
        if (this.getProvider(provider.getName()) != null) {
            throw new IllegalArgumentException("Provider already registered: " + provider.getName());
        }
        this.providers.put(provider.getName(), provider);
    }

    @Override
    public SecurityProvider getProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("provider Name cannot be null");
        }
        return this.providers.get(name);
    }

    @Override
    public SecurityProvider removeProvider(String name) {
        return this.providers.remove(name);
    }

    @Override
    public Collection<SecurityProvider> getProviders() {
        ArrayList<SecurityProvider> providersList = new ArrayList<SecurityProvider>(this.providers.values());
        return Collections.unmodifiableCollection(providersList);
    }

    @Override
    public void setProviders(Collection<SecurityProvider> providers) {
        for (SecurityProvider provider : providers) {
            this.addProvider(provider);
        }
    }

    @Override
    public SecurityContext createSecurityContext(Authentication authentication) throws UnknownAuthenticationTypeException {
        Iterator<SecurityProvider> iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            SecurityProvider provider = iter.next();
            if (!provider.supports(toTest)) continue;
            return provider.createSecurityContext(authentication);
        }
        throw new UnknownAuthenticationTypeException(authentication);
    }

    @Override
    public EncryptionStrategy getEncryptionStrategy(String name) {
        return this.cryptoStrategies.get(name);
    }

    @Override
    public void addEncryptionStrategy(EncryptionStrategy strategy) {
        this.cryptoStrategies.put(strategy.getName(), strategy);
    }

    @Override
    public EncryptionStrategy removeEncryptionStrategy(String name) {
        return this.cryptoStrategies.remove(name);
    }

    @Override
    public Collection<EncryptionStrategy> getEncryptionStrategies() {
        ArrayList<EncryptionStrategy> allStrategies = new ArrayList<EncryptionStrategy>(this.cryptoStrategies.values());
        return Collections.unmodifiableCollection(allStrategies);
    }

    @Override
    public void setEncryptionStrategies(Collection<EncryptionStrategy> strategies) {
        for (EncryptionStrategy strategy : strategies) {
            this.addEncryptionStrategy(strategy);
        }
    }
}

