/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.apache.commons.lang.BooleanUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class AsyncReplySendInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor {
    public MuleEvent process(MuleEvent event) throws MuleException {
        Object replyTo = event.getMessage().getReplyTo();
        ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), (InboundEndpoint)event.getEndpoint());
        event.getMessage().setReplyTo(null);
        MuleEvent resultEvent = this.processNext(event);
        if (resultEvent != null && !BooleanUtils.toBoolean((String)((String)resultEvent.getProperty("MULE_REPLYTO_STOP")))) {
            this.processReplyTo(event, resultEvent, replyToHandler, replyTo);
        }
        return resultEvent;
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, InboundEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    protected void processReplyTo(MuleEvent event, MuleEvent result, ReplyToHandler replyToHandler, Object replyTo) throws MuleException {
        String requestor;
        if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(event.getFlowConstruct().getName()) || requestor == null)) {
            replyToHandler.processReplyTo(event, result.getMessage(), replyTo);
        }
    }
}

