/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private List<Transformer> transformers = new LinkedList<Transformer>();
    private Filter filter;
    private boolean useTemplates = true;
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();
    protected ExpressionManager expressionManager;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleEvent result = null;
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        OutboundEndpoint ep = this.getEndpoint(0, message);
        try {
            if (ep.isSynchronous()) {
                result = this.sendRequest(session, message, ep, true);
            } else {
                this.sendRequest(session, message, ep, false);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
        return result;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isMatch(MuleMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        try {
            message.applyTransformers(this.transformers);
        }
        catch (TransformerException e) {
            throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (ImmutableEndpoint)this.endpoints.get(0), e);
        }
        return this.getFilter().accept(message);
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    @Override
    public void addEndpoint(OutboundEndpoint endpoint) {
        if (!this.useTemplates && this.parser.isContainsTemplate(endpoint.getEndpointURI().toString())) {
            this.useTemplates = true;
        }
        super.addEndpoint(endpoint);
    }

    public OutboundEndpoint getEndpoint(int index, MuleMessage message) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (OutboundEndpoint)this.endpoints.get(index);
        }
        OutboundEndpoint ep = (OutboundEndpoint)this.endpoints.get(index);
        String uri = ep.getEndpointURI().getUri().toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + uri));
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(ep.getProperties());
        for (String propertyKey : message.getPropertyNames()) {
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        if (!this.parser.isContainsTemplate(uri)) {
            this.logger.debug((Object)"Uri does not contain template(s)");
            return ep;
        }
        String newUriString = this.parser.parse(props, uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + uri));
        }
        try {
            MuleEndpointURI newUri = new MuleEndpointURI(newUriString, this.muleContext);
            if (!newUri.getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            return new DynamicURIOutboundEndpoint(ep, newUri);
        }
        catch (EndpointException e) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.templateCausedMalformedEndpoint(uri, newUriString), message, ep, e);
        }
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    @Override
    public boolean isRequiresNewMessage() {
        return !this.transformers.isEmpty();
    }
}

