/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.ExpressionRecipientList;

public class ExceptionBasedRouter
extends ExpressionRecipientList {
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        ArrayList<OutboundEndpoint> recipients = null;
        try {
            recipients = this.getRecipients(message);
        }
        catch (RequiredValueException e) {
            // empty catch block
        }
        if (recipients == null) {
            int endpointsCount = this.endpoints.size();
            recipients = new ArrayList<OutboundEndpoint>(endpointsCount);
            for (int i = 0; i < endpointsCount; ++i) {
                recipients.add(this.getEndpoint(i, message));
            }
        }
        if (recipients == null || recipients.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(recipients.size());
            }
        }
        MuleEvent result = null;
        OutboundEndpoint endpoint = null;
        DefaultMuleMessage request = null;
        boolean success = false;
        Iterator iterator = recipients.iterator();
        while (iterator.hasNext()) {
            boolean lastEndpoint;
            request = new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
            endpoint = this.getRecipientEndpoint(request, iterator.next());
            boolean bl = lastEndpoint = !iterator.hasNext();
            if (!lastEndpoint) {
                this.logger.info((Object)("Sync mode will be forced for " + endpoint.getEndpointURI() + ", as there are more endpoints available."));
            }
            if (!lastEndpoint || endpoint.isSynchronous()) {
                try {
                    MuleMessage resultMessage = null;
                    result = this.sendRequest(session, request, endpoint, true);
                    if (result != null) {
                        resultMessage = result.getMessage();
                    }
                    if (resultMessage != null) {
                        resultMessage.applyTransformers(endpoint.getResponseTransformers());
                    }
                    if (this.exceptionPayloadAvailable(resultMessage)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Successful invocation detected, stopping further processing.");
                    }
                    success = true;
                    break;
                }
                catch (MuleException e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    Throwable t = ExceptionHelper.getRootException(e);
                    this.logger.warn((Object)("Failed to send to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + t + ". Trying next endpoint"), t);
                    continue;
                }
            }
            try {
                this.sendRequest(session, request, endpoint, false);
                success = true;
                break;
            }
            catch (MuleException e) {
                this.logger.info((Object)("Failed to dispatch to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + e.getMessage() + ". Trying next endpoint"));
            }
        }
        if (!success) {
            throw new CouldNotRouteOutboundMessageException(request, endpoint);
        }
        return result;
    }

    protected boolean exceptionPayloadAvailable(MuleMessage message) {
        if (message == null) {
            return false;
        }
        ExceptionPayload exceptionPayload = message.getExceptionPayload();
        if (exceptionPayload != null) {
            this.logger.info((Object)("Failure returned, will try next endpoint. Exception payload is: " + exceptionPayload));
            return true;
        }
        return false;
    }
}

