/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouter;
import org.mule.routing.MuleMessageInfoMapping;
import org.mule.routing.outbound.DefaultRouterResultsHandler;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutboundRouter
extends AbstractRouter
implements OutboundRouter {
    public static final int ENABLE_CORRELATION_IF_NOT_SET = 0;
    public static final int ENABLE_CORRELATION_ALWAYS = 1;
    public static final int ENABLE_CORRELATION_NEVER = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List<OutboundEndpoint> endpoints = new CopyOnWriteArrayList();
    protected String replyTo = null;
    protected int enableCorrelation = 0;
    protected MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();
    protected TransactionConfig transactionConfig;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.route(event);
    }

    protected abstract MuleEvent route(MuleEvent var1) throws RoutingException, MessagingException;

    protected final MuleEvent sendRequest(MuleSession session, MuleMessage message, OutboundEndpoint endpoint, boolean awaitResponse) throws MuleException {
        if (awaitResponse && this.replyTo != null) {
            this.logger.debug((Object)"event was dispatched synchronously, but there is a ReplyTo endpoint set, so using asynchronous dispatch");
            awaitResponse = false;
        }
        this.setMessageProperties(session.getFlowConstruct(), message, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message being sent to: " + endpoint.getEndpointURI()));
            this.logger.debug((Object)message);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Request payload: \n" + StringMessageUtils.truncate(message.getPayloadAsString(), 100, false) + "\n outbound transformer is: " + endpoint.getTransformers()));
            }
            catch (Exception e) {
                this.logger.trace((Object)("Request payload: \n(unable to retrieve payload: " + e.getMessage() + "\n outbound transformer is: " + endpoint.getTransformers()));
            }
        }
        MuleEvent result = null;
        try {
            result = this.sendRequestEvent(session, message, endpoint, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(message, null, (Throwable)e);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(endpoint);
        }
        if (result != null) {
            MuleMessage resultMessage = result.getMessage();
            if (this.logger.isTraceEnabled() && resultMessage != null) {
                try {
                    this.logger.trace((Object)("Response payload: \n" + StringMessageUtils.truncate(resultMessage.getPayloadAsString(), 100, false)));
                }
                catch (Exception e) {
                    this.logger.trace((Object)("Response payload: \n(unable to retrieve payload: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    protected void setMessageProperties(FlowConstruct service, MuleMessage message, OutboundEndpoint endpoint) {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setProperty("MULE_REPLYTO_REQUESTOR", service.getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting replyTo=" + this.replyTo + " for outbound endpoint: " + endpoint.getEndpointURI()));
            }
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "' , not setting it again"));
                }
                return;
            }
            if (correlationSet) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "', but router is configured to overwrite it"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No CorrelationId is set on the message, will set a new Id");
            }
            String correlation = this.messageInfoMapping.getCorrelationId(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extracted correlation Id as: " + correlation));
            }
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info on Outbound router for endpoint: ").append(endpoint.getEndpointURI());
                buf.append(SystemUtils.LINE_SEPARATOR).append("Id=").append(correlation);
                this.logger.debug((Object)buf.toString());
            }
            message.setCorrelationId(correlation);
        }
    }

    @Override
    public List<OutboundEndpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<OutboundEndpoint> endpoints) {
        this.endpoints.clear();
        for (OutboundEndpoint endpoint : endpoints) {
            this.addEndpoint(endpoint);
        }
    }

    @Override
    public void addEndpoint(OutboundEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    @Override
    public boolean removeEndpoint(OutboundEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public int getEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(int enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableCorrelationAsString(String enableCorrelation) {
        if (enableCorrelation != null) {
            if (enableCorrelation.equals("ALWAYS")) {
                this.enableCorrelation = 1;
            } else if (enableCorrelation.equals("NEVER")) {
                this.enableCorrelation = 2;
            } else if (enableCorrelation.equals("IF_NOT_SET")) {
                this.enableCorrelation = 0;
            } else {
                throw new IllegalArgumentException("Value for enableCorrelation not recognised: " + enableCorrelation);
            }
        }
    }

    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public boolean isDynamicEndpoints() {
        return false;
    }

    @Override
    public OutboundEndpoint getEndpoint(String name) {
        for (OutboundEndpoint endpointDescriptor : this.endpoints) {
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }

    public RouterResultsHandler getResultsHandler() {
        return this.resultsHandler;
    }

    public void setResultsHandler(RouterResultsHandler resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    @Override
    public boolean isRequiresNewMessage() {
        return false;
    }

    private MuleEvent sendRequestEvent(MuleSession session, MuleMessage message, OutboundEndpoint endpoint, boolean awaitResponse) throws MuleException {
        int timeout;
        if (endpoint == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), message, endpoint);
        }
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, session, endpoint.isSynchronous(), null);
        if (awaitResponse && (timeout = message.getIntProperty("MULE_EVENT_TIMEOUT", -1)) >= 0) {
            event.setTimeout(timeout);
        }
        return endpoint.process(event);
    }

    protected final MuleMessage getMessage(MuleEvent event) {
        return event == null ? null : event.getMessage();
    }

    protected final MuleEvent createEvent(MuleMessage message, MuleEvent previous) {
        return message == null ? null : new DefaultMuleEvent(message, previous);
    }
}

