/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.routing.inbound.SelectiveConsumer;

public class ForwardingConsumer
extends SelectiveConsumer {
    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        if (super.process(event) != null) {
            if (!(event.getFlowConstruct() instanceof Service)) {
                throw new UnsupportedOperationException("ForwardingConsumer is only supported with Service");
            }
            OutboundRouterCollection router = ((Service)event.getFlowConstruct()).getOutboundRouter();
            event.setStopFurtherProcessing(true);
            if (router == null) {
                this.logger.debug((Object)"Descriptor has no outbound router configured to forward to, continuing with normal processing");
                return new MuleEvent[]{event};
            }
            try {
                MuleEvent resultEvent = router.process(event);
                if (resultEvent != null) {
                    return new MuleEvent[]{resultEvent};
                }
                return null;
            }
            catch (MuleException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return null;
    }
}

