/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.RoutingException;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.routing.AbstractRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.source.StartablePatternAwareCompositeMessageSource;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInboundRouterCollection
extends AbstractRouterCollection
implements InboundRouterCollection {
    protected CompositeMessageSource compositeMessageSource = new StartablePatternAwareCompositeMessageSource();
    protected final List<InboundEndpoint> endpoints = new CopyOnWriteArrayList();
    protected MessageProcessor listener;

    public DefaultInboundRouterCollection() {
        super(1);
        this.setMatchAll(true);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MessagingException {
        if (this.endpoints.size() > 0 && this.routers.size() == 0) {
            this.addRouter(new InboundPassThroughRouter());
        }
        String componentName = event.getFlowConstruct().getName();
        LinkedHashMap<String, MuleEvent> eventsToRoute = new LinkedHashMap<String, MuleEvent>(2);
        boolean noRoute = true;
        boolean match = false;
        MuleEvent lastEvent = null;
        for (InboundRouter inboundRouter : this.getRouters()) {
            if (!inboundRouter.isMatch(event)) continue;
            match = true;
            MuleEvent[] events = inboundRouter.process(event);
            if (events != null) {
                MuleEvent[] arr$ = events;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    MuleEvent event1;
                    lastEvent = event1 = arr$[i$];
                    eventsToRoute.put(lastEvent.getId(), lastEvent);
                }
            }
            boolean bl = noRoute = events == null;
            if (this.isMatchAll()) continue;
            break;
        }
        if (!event.isStopFurtherProcessing()) {
            if (noRoute) {
                if (this.getStatistics().isEnabled()) {
                    this.getStatistics().incrementNoRoutedMessage();
                }
                if (!match) {
                    if (this.getCatchAllStrategy() != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Message did not match any routers on: " + componentName + " - invoking catch all strategy"));
                        }
                        if (this.getStatistics().isEnabled()) {
                            this.getStatistics().incrementCaughtMessage();
                        }
                        return this.getCatchAllStrategy().process(event);
                    }
                    this.logger.warn((Object)("Message did not match any routers on: " + componentName + " and there is no catch all strategy configured on this router.  Disposing message: " + event));
                    if (this.logger.isDebugEnabled()) {
                        try {
                            this.logger.warn((Object)("Message fragment is: " + StringMessageUtils.truncate(event.getMessageAsString(), 100, true)));
                        }
                        catch (MuleException e) {}
                    }
                }
            } else {
                try {
                    MuleEvent messageResult = null;
                    for (MuleEvent eventToRoute : eventsToRoute.values()) {
                        messageResult = this.listener.process(eventToRoute);
                        if (!this.getStatistics().isEnabled()) continue;
                        this.getStatistics().incrementRoutedMessage(eventToRoute.getEndpoint());
                    }
                    return messageResult;
                }
                catch (MuleException e) {
                    throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
                }
            }
        }
        if (event.isSynchronous()) {
            return lastEvent;
        }
        return null;
    }

    @Override
    public void addRouter(InboundRouter router) {
        this.routers.add(router);
    }

    @Override
    public InboundRouter removeRouter(InboundRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    @Override
    public void addEndpoint(InboundEndpoint endpoint) throws MuleException {
        this.endpoints.add(endpoint);
        this.compositeMessageSource.addSource(endpoint);
    }

    @Override
    public boolean removeEndpoint(InboundEndpoint endpoint) throws MuleException {
        this.compositeMessageSource.removeSource(endpoint);
        return this.endpoints.remove(endpoint);
    }

    @Override
    public List<InboundEndpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<InboundEndpoint> endpointList) throws MuleException {
        if (this.endpoints != null) {
            for (InboundEndpoint endpoint : this.endpoints) {
                this.removeEndpoint(endpoint);
            }
            this.endpoints.clear();
            for (InboundEndpoint endpoint : endpointList) {
                this.addEndpoint(endpoint);
            }
        } else {
            throw new IllegalArgumentException("List of endpoints = null");
        }
    }

    @Override
    public InboundEndpoint getEndpoint(String name) {
        for (InboundEndpoint endpoint : this.endpoints) {
            if (!endpoint.getName().equals(name)) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.listener = listener;
    }

    public MessageSource getMessageSource() {
        return this.compositeMessageSource;
    }
}

