/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.routing.Router;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.RouterCollection;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractCatchAllStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRouterCollection
implements RouterCollection,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected boolean matchAll = false;
    protected List<Router> routers = new CopyOnWriteArrayList();
    protected RouterStatistics statistics;
    private RouterCatchAllStrategy catchAllStrategy;
    protected MuleContext muleContext;

    public AbstractRouterCollection(int type) {
        this.statistics = new RouterStatistics(type);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleTransitionResult.initialiseAll(this.routers.iterator());
    }

    @Override
    public void dispose() {
        for (Router router : this.routers) {
            router.dispose();
        }
    }

    @Override
    public void setRouters(List<? extends Router> routers) {
        for (Router router : routers) {
            this.addRouter(router);
        }
    }

    @Override
    public void addRouter(Router router) {
        router.setRouterStatistics(this.getStatistics());
        this.routers.add(router);
    }

    @Override
    public Router removeRouter(Router router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    @Override
    public RouterCatchAllStrategy getCatchAllStrategy() {
        return this.catchAllStrategy;
    }

    @Override
    public void setCatchAllStrategy(RouterCatchAllStrategy catchAllStrategy) {
        this.catchAllStrategy = catchAllStrategy;
        if (this.catchAllStrategy != null && catchAllStrategy instanceof AbstractCatchAllStrategy) {
            ((AbstractCatchAllStrategy)this.catchAllStrategy).setStatistics(this.statistics);
        }
    }

    @Override
    public boolean isMatchAll() {
        return this.matchAll;
    }

    @Override
    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    @Override
    public RouterStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(RouterStatistics stat) {
        this.statistics = stat;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

