/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerChain;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.types.SimpleDataType;

public class TypeBasedTransformerResolver
implements TransformerResolver,
MuleContextAware,
Disposable,
Initialisable {
    protected final transient Log logger = LogFactory.getLog(TypeBasedTransformerResolver.class);
    private ObjectToString objectToString;
    private ObjectToByteArray objectToByteArray;
    private MuleContext muleContext;
    protected Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap(8);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        try {
            this.objectToString = new ObjectToString();
            this.objectToByteArray = new ObjectToByteArray();
            this.muleContext.getRegistry().applyProcessorsAndLifecycle(this.objectToString);
            this.muleContext.getRegistry().applyProcessorsAndLifecycle(this.objectToByteArray);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        Transformer transformer = this.exactTransformerCache.get(source.toString() + result.toString());
        if (transformer != null) {
            return transformer;
        }
        List<Transformer> trans = this.muleContext.getRegistry().lookupTransformers(source, result);
        transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType());
        AbstractTransformer secondPass = null;
        if (transformer == null) {
            if (result.getType().equals(String.class)) {
                secondPass = this.objectToString;
            } else if (result.getType().equals(byte[].class)) {
                secondPass = this.objectToByteArray;
            } else {
                return null;
            }
            trans = this.muleContext.getRegistry().lookupTransformers(source, new SimpleDataType(Object.class));
            transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType());
            if (transformer != null) {
                transformer = new TransformerChain(transformer, secondPass);
                try {
                    this.muleContext.getRegistry().registerTransformer(transformer);
                }
                catch (MuleException e) {
                    throw new ResolverException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        if (transformer != null) {
            this.exactTransformerCache.put(source.toString() + result.toString(), transformer);
        }
        return transformer;
    }

    protected Transformer getNearestTransformerMatch(List trans, Class input, Class output) throws ResolverException {
        if (trans.size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Comparing transformers for best match: input = " + input + " output = " + output + " Possible transformers = " + trans));
            }
            TransformerWeighting weighting = null;
            for (Transformer transformer : trans) {
                TransformerWeighting current = new TransformerWeighting(input, output, transformer);
                if (weighting == null) {
                    weighting = current;
                    continue;
                }
                int compare = current.compareTo(weighting);
                if (compare == 1) {
                    weighting = current;
                    continue;
                }
                if (compare != 0 || weighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                throw new ResolverException(CoreMessages.transformHasMultipleMatches(input, output, current.getTransformer(), weighting.getTransformer()));
            }
            return weighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return (Transformer)trans.get(0);
    }

    public void dispose() {
        this.exactTransformerCache.clear();
    }

    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        if (transformer instanceof DiscoverableTransformer) {
            this.exactTransformerCache.clear();
        }
    }
}

