/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.NullMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptingChainMessageProcessorBuilder
implements MessageProcessorBuilder {
    protected List<MessageProcessor> chain = new ArrayList<MessageProcessor>();
    protected String name;

    @Override
    public MessageProcessor build() {
        if (this.chain.isEmpty()) {
            return new NullMessageProcessor();
        }
        InterceptingMessageProcessor first = this.createInterceptingMessageProcessor(this.chain.get(0));
        InterceptingChainCompositeMessageProcessor composite = new InterceptingChainCompositeMessageProcessor(first, this.chain, this.name);
        InterceptingMessageProcessor current = first;
        for (int i = 1; i < this.chain.size(); ++i) {
            InterceptingMessageProcessor mp = this.createInterceptingMessageProcessor(this.chain.get(i));
            current.setListener(mp);
            current = mp;
        }
        return composite;
    }

    public void setName(String name) {
        this.name = name;
    }

    private InterceptingMessageProcessor createInterceptingMessageProcessor(MessageProcessor processor) {
        if (processor instanceof InterceptingMessageProcessor) {
            return (InterceptingMessageProcessor)processor;
        }
        return new InterceptingMessageProcessorAdapter(processor);
    }

    public InterceptingChainMessageProcessorBuilder chain(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.chain.add(messageProcessor);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chain(Collection<MessageProcessor> processors) {
        if (processors != null) {
            this.chain.addAll(processors);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chainBefore(MessageProcessor processor) {
        this.chain.add(0, processor);
        return this;
    }

    public String toString() {
        if (this.name != null) {
            return "InterceptingChainMessageProcessorBuilder '" + this.name + "'";
        }
        return super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InterceptingChainCompositeMessageProcessor
    implements MessageProcessor,
    Lifecycle,
    FlowConstructAware {
        private Log log;
        private String name;
        private MessageProcessor firstInChain;
        private List<MessageProcessor> allProcessors;

        public InterceptingChainCompositeMessageProcessor(InterceptingMessageProcessor firstInChain, List<MessageProcessor> allProcessors, String name) {
            this.name = name;
            this.firstInChain = firstInChain;
            this.allProcessors = allProcessors;
            this.log = LogFactory.getLog(InterceptingChainCompositeMessageProcessor.class);
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + this + " with event " + event));
            }
            return this.firstInChain.process(event);
        }

        @Override
        public void initialise() throws InitialisationException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Initialisable)) continue;
                ((Initialisable)((Object)processor)).initialise();
            }
        }

        @Override
        public void start() throws MuleException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
            }
        }

        @Override
        public void stop() throws MuleException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Stoppable)) continue;
                ((Stoppable)((Object)processor)).stop();
            }
        }

        @Override
        public void dispose() {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Disposable)) continue;
                ((Disposable)((Object)processor)).dispose();
            }
        }

        @Override
        public void setFlowConstruct(FlowConstruct flowConstruct) {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof FlowConstructAware)) continue;
                ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
            }
        }

        public String toString() {
            StringBuffer string = new StringBuffer();
            string.append("InterceptingChainCompositeMessageProcessor ");
            if (this.name != null) {
                string.append(" '" + this.name + "' ");
            } else {
                string.append("[ processors= ");
                Iterator<MessageProcessor> mpIterator = this.allProcessors.iterator();
                while (mpIterator.hasNext()) {
                    MessageProcessor mp = mpIterator.next();
                    string.append(mp.getClass().getName());
                    if (!mpIterator.hasNext()) continue;
                    string.append(", ");
                }
                string.append(" ]");
            }
            return string.toString();
        }
    }

    static class InterceptingMessageProcessorAdapter
    extends AbstractInterceptingMessageProcessor {
        private MessageProcessor delegate;

        public InterceptingMessageProcessorAdapter(MessageProcessor mp) {
            this.delegate = mp;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking adapted MessageProcessor '" + this.delegate.getClass().getName() + "'"));
            }
            return this.processNext(this.delegate.process(event));
        }

        public void setNext(MessageProcessor next) {
            this.next = next;
        }

        public String toString() {
            return "InterceptingMessageProcessorAdapter [ target = '" + this.delegate.getClass().getName() + "' ]";
        }
    }
}

