/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.AbstractEntryPointResolver;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class ReflectionEntryPointResolver
extends AbstractEntryPointResolver {
    private Set ignoredMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler", "set*", "toString", "getClass", "notify", "notifyAll", "wait", "hashCode", "clone", "is*", "get*"));
    protected WildcardFilter filter;

    public ReflectionEntryPointResolver() {
        this.updateFilter();
    }

    private void updateFilter() {
        this.filter = new WildcardFilter(StringUtils.join((Collection)this.ignoredMethods, (char)','));
    }

    public Collection getIgnoredMethods() {
        return Collections.unmodifiableSet(this.ignoredMethods);
    }

    public void setIgnoredMethods(Collection methods) {
        this.ignoredMethods = new HashSet(methods);
        this.updateFilter();
    }

    public void addIgnoredMethod(String name) {
        this.ignoredMethods.add(name);
        this.updateFilter();
    }

    public boolean removeIgnoredMethod(String name) {
        boolean result = this.ignoredMethods.remove(name);
        this.updateFilter();
        return result;
    }

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        Object[] payload = this.getPayloadFromMessage(context);
        Method method = this.getMethodByArguments(component, payload);
        if (method != null) {
            return this.invokeMethod(component, method, payload);
        }
        Class[] types = ClassUtils.getClassTypes(payload);
        List methods = ClassUtils.getSatisfiableMethods(component.getClass(), types, this.isAcceptVoidMethods(), false, this.ignoredMethods, this.filter);
        int numMethods = methods.size();
        if (numMethods > 1) {
            InvocationResult result = new InvocationResult(2);
            result.setErrorTooManyMatchingMethods(component, types, StringMessageUtils.toString(methods), this);
            return result;
        }
        if (numMethods == 1) {
            method = this.addMethodByArguments(component, (Method)methods.get(0), payload);
        } else {
            methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, this.ignoredMethods);
            numMethods = methods.size();
            if (numMethods > 1) {
                InvocationResult result = new InvocationResult(2);
                result.setErrorTooManyMatchingMethods(component, types, StringMessageUtils.toString(methods), this);
                return result;
            }
            if (numMethods == 1) {
                method = this.addMethodByArguments(component, (Method)methods.get(0), payload);
            } else {
                InvocationResult result = new InvocationResult(2);
                result.setErrorNoMatchingMethods(component, ClassUtils.getClassTypes(payload), this);
                return result;
            }
        }
        return this.invokeMethod(component, method, payload);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReflectionEntryPointResolver");
        sb.append("{ignoredMethods=").append(StringMessageUtils.toString(this.ignoredMethods));
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

