/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.LifecycleStateEnabled;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.LifecycleObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecyclePhase
implements LifecyclePhase,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(DefaultLifecyclePhase.class);
    private Class<?> lifecycleClass;
    private Method lifecycleMethod;
    private Set<LifecycleObject> orderedLifecycleObjects = new LinkedHashSet<LifecycleObject>(6);
    private Class<?>[] ignorredObjectTypes;
    private String name;
    private String oppositeLifecyclePhase;
    private Set<String> supportedPhases;
    private MuleContext muleContext;

    public DefaultLifecyclePhase(String name, Class<?> lifecycleClass, String oppositeLifecyclePhase) {
        this.name = name;
        this.lifecycleClass = lifecycleClass;
        this.lifecycleMethod = lifecycleClass.getMethods()[0];
        this.oppositeLifecyclePhase = oppositeLifecyclePhase;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected List sortLifecycleInstances(Collection objects, LifecycleObject lo) {
        return new ArrayList(objects);
    }

    @Override
    public void addOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.add(lco);
    }

    @Override
    public void removeOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.remove(lco);
    }

    protected boolean ignoreType(Class<?> type) {
        if (this.ignorredObjectTypes == null) {
            return false;
        }
        for (int i = 0; i < this.ignorredObjectTypes.length; ++i) {
            Class<?> ignorredObjectType = this.ignorredObjectTypes[i];
            if (!ignorredObjectType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<LifecycleObject> getOrderedLifecycleObjects() {
        return this.orderedLifecycleObjects;
    }

    @Override
    public void setOrderedLifecycleObjects(Set<LifecycleObject> orderedLifecycleObjects) {
        this.orderedLifecycleObjects = orderedLifecycleObjects;
    }

    @Override
    public Class<?>[] getIgnoredObjectTypes() {
        return this.ignorredObjectTypes;
    }

    @Override
    public void setIgnoredObjectTypes(Class<?>[] ignorredObjectTypes) {
        this.ignorredObjectTypes = ignorredObjectTypes;
    }

    @Override
    public Class<?> getLifecycleClass() {
        return this.lifecycleClass;
    }

    @Override
    public void setLifecycleClass(Class<?> lifecycleClass) {
        this.lifecycleClass = lifecycleClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getSupportedPhases() {
        return this.supportedPhases;
    }

    @Override
    public void setSupportedPhases(Set<String> supportedPhases) {
        this.supportedPhases = supportedPhases;
    }

    @Override
    public void registerSupportedPhase(String phase) {
        if (this.supportedPhases == null) {
            this.supportedPhases = new HashSet<String>();
        }
        this.supportedPhases.add(phase);
    }

    @Override
    public boolean isPhaseSupported(String phase) {
        if (this.getSupportedPhases() == null) {
            return false;
        }
        if (this.getSupportedPhases().contains("all")) {
            return true;
        }
        return this.getSupportedPhases().contains(phase);
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        if (!this.getLifecycleClass().isAssignableFrom(o.getClass())) {
            return;
        }
        if (o instanceof LifecycleStateEnabled && ((LifecycleStateEnabled)o).getLifecycleState().isPhaseComplete(this.getName())) {
            return;
        }
        try {
            this.lifecycleMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(this.lifecycleMethod.getName(), o), e, this);
        }
    }

    @Override
    public String getOppositeLifecyclePhase() {
        return this.oppositeLifecyclePhase;
    }
}

