/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;

public class InterceptorStack
extends AbstractInterceptingMessageProcessor
implements Interceptor,
Initialisable,
Disposable {
    private List<Interceptor> interceptors;
    private MessageProcessor chain;

    public InterceptorStack() {
    }

    public InterceptorStack(List interceptors) {
        this.interceptors = interceptors;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.chain.process(event);
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public void initialise() throws InitialisationException {
        InterceptingChainMessageProcessorBuilder chainBuilder = new InterceptingChainMessageProcessorBuilder();
        for (Interceptor interceptor : this.interceptors) {
            if (interceptor instanceof Initialisable) {
                ((Initialisable)((Object)interceptor)).initialise();
            }
            chainBuilder.chain(interceptor);
        }
        if (this.next != null) {
            chainBuilder.chain(this.next);
        }
        this.chain = chainBuilder.build();
    }

    public void dispose() {
        for (Interceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof Disposable)) continue;
            ((Disposable)((Object)interceptor)).dispose();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interceptors == null ? 0 : ((Object)this.interceptors).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterceptorStack other = (InterceptorStack)obj;
        return !(this.interceptors == null ? other.interceptors != null : !((Object)this.interceptors).equals(other.interceptors));
    }
}

