/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.security.SecurityException;
import org.mule.api.transport.DispatchException;
import org.mule.context.notification.SecurityNotification;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class OutboundSecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor {
    private OutboundEndpoint endpoint;

    public OutboundSecurityFilterMessageProcessor(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        if (this.endpoint.getSecurityFilter() != null) {
            try {
                this.endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                connector.fireNotification(new SecurityNotification(e, 401));
                connector.handleException(e);
                return event;
            }
            catch (Exception e) {
                connector.handleException(e);
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return this.processNext(event);
    }
}

