/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.security.SecurityException;
import org.mule.api.transport.MessageReceiver;
import org.mule.context.notification.SecurityNotification;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class InboundSecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected InboundEndpoint endpoint;

    public InboundSecurityFilterMessageProcessor(InboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        MessageReceiver receiver = connector.getReceiver(event.getFlowConstruct(), this.endpoint);
        MuleEvent resultEvent = null;
        boolean authorised = false;
        if (this.endpoint.getSecurityFilter() != null) {
            try {
                this.endpoint.getSecurityFilter().authenticate(event);
                authorised = true;
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                ((AbstractConnector)this.endpoint.getConnector()).fireNotification(new SecurityNotification(e, 401));
                connector.handleException(e, receiver);
                resultEvent = RequestContext.getEvent();
                resultEvent.getMessage().setPayload(e.getLocalizedMessage());
            }
        } else {
            authorised = true;
        }
        if (authorised) {
            resultEvent = this.processNext(event);
        }
        return resultEvent;
    }
}

