/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connector;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInboundEndpoint
extends AbstractEndpoint
implements InboundEndpoint {
    private static final long serialVersionUID = -4752772777414636142L;
    private MessageProcessor listener;
    private FlowConstruct flowConstruct;

    public DefaultInboundEndpoint(Connector connector, EndpointURI endpointUri, List transformers, List responseTransformers, String name, Map properties, TransactionConfig transactionConfig, Filter filter, boolean deleteUnacceptedMessage, EndpointSecurityFilter securityFilter, boolean synchronous, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors) {
        super(connector, endpointUri, transformers, responseTransformers, name, properties, transactionConfig, filter, deleteUnacceptedMessage, securityFilter, synchronous, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate, messageProcessorsFactory, messageProcessors, responseMessageProcessors);
    }

    @Override
    public MuleMessage request(long timeout) throws Exception {
        if (this.getConnector() != null) {
            return this.getConnector().request(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.listener = listener;
    }

    @Override
    public void start() throws MuleException {
        try {
            this.getConnector().registerListener(this, this.getMessageProcessorChain(), this.flowConstruct);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStartInboundEndpoint(this), e, this);
        }
    }

    @Override
    public void stop() throws MuleException {
        try {
            this.getConnector().unregisterListener(this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStartInboundEndpoint(this), e, this);
        }
    }

    @Override
    public MessageProcessor createMessageProcessorChain() throws MuleException {
        EndpointMessageProcessorChainFactory factory = this.getMessageProcessorsFactory();
        return factory.createInboundMessageProcessorChain(this, this.listener);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

