/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.endpoint.DefaultEndpointMessageProcessorChainFactory;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.endpoint.URIBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.MapCombiner;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    public static final String PROPERTY_RESPONSE_TIMEOUT = "responseTimeout";
    public static final String PROPERTY_RESPONSE_PROPERTIES = "responseProperties";
    protected URIBuilder uriBuilder;
    protected Connector connector;
    protected List<Transformer> transformers;
    protected List<Transformer> responseTransformers;
    protected String name;
    protected Map<Object, Object> properties = new HashMap<Object, Object>();
    protected TransactionConfig transactionConfig;
    protected Filter filter;
    protected Boolean deleteUnacceptedMessages;
    protected EndpointSecurityFilter securityFilter;
    protected Boolean synchronous;
    protected MessageExchangePattern messageExchangePattern;
    protected Integer responseTimeout;
    protected String initialState = "started";
    protected String encoding;
    protected Integer createConnector;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected String responsePropertiesList;
    protected EndpointMessageProcessorChainFactory messageProcessorsFactory;
    protected List<MessageProcessor> messageProcessors;
    protected List<MessageProcessor> responseMessageProcessors;
    protected String registryId = null;
    protected MuleContext muleContext;

    @Override
    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildInboundEndpoint();
    }

    @Override
    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildOutboundEndpoint();
    }

    protected void setPropertiesFromProperties(Map<Object, Object> properties) {
        this.synchronous = AbstractEndpointBuilder.getBooleanProperty(properties, "synchronous", this.synchronous);
        String mepString = (String)properties.get("exchange-pattern");
        if (StringUtils.isNotEmpty((String)mepString)) {
            mepString = mepString.toUpperCase().replace('-', '_');
            this.setExchangePattern(MessageExchangePattern.valueOf(mepString));
        }
        this.responseTimeout = AbstractEndpointBuilder.getIntegerProperty(properties, PROPERTY_RESPONSE_TIMEOUT, this.responseTimeout);
        this.responsePropertiesList = (String)properties.get(PROPERTY_RESPONSE_PROPERTIES);
    }

    private static Boolean getBooleanProperty(Map<Object, Object> properties, String name, Boolean dflt) {
        if (properties.containsKey(name)) {
            return Boolean.valueOf((String)properties.get(name));
        }
        return dflt;
    }

    private static Integer getIntegerProperty(Map<Object, Object> properties, String name, Integer dflt) {
        if (properties.containsKey(name)) {
            return Integer.decode((String)properties.get(name));
        }
        return dflt;
    }

    protected InboundEndpoint doBuildInboundEndpoint() throws InitialisationException, EndpointException {
        Map<Object, Object> properties = this.getProperties();
        this.setPropertiesFromProperties(properties);
        if (this.uriBuilder == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("uriBuilder"));
        }
        this.uriBuilder.setMuleContext(this.muleContext);
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        Connector connector = this.getConnector();
        if (connector != null && !connector.supportsProtocol(endpointURI.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        List<Transformer> transformers = this.getInboundTransformers(connector, endpointURI);
        List<Transformer> responseTransformers = this.getInboundEndpointResponseTransformers(connector, endpointURI);
        boolean synchronous = this.getSynchronous(connector, endpointURI);
        return new DefaultInboundEndpoint(connector, endpointURI, transformers, responseTransformers, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getFilter(connector), this.getDefaultDeleteUnacceptedMessages(connector), this.getSecurityFilter(), synchronous, this.getResponseTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.name, this.muleContext, this.getRetryPolicyTemplate(connector), this.getMessageProcessorsFactory(), this.messageProcessors, this.responseMessageProcessors);
    }

    protected OutboundEndpoint doBuildOutboundEndpoint() throws InitialisationException, EndpointException {
        Map<Object, Object> properties = this.getProperties();
        this.setPropertiesFromProperties(properties);
        if (this.uriBuilder == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("uriBuilder"));
        }
        this.uriBuilder.setMuleContext(this.muleContext);
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        Connector connector = this.getConnector();
        if (connector != null && !connector.supportsProtocol(endpointURI.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        List<Transformer> transformers = this.getOutboundTransformers(connector, endpointURI);
        List<Transformer> responseTransformers = this.getOutboundEndpointResponseTransformers(connector, endpointURI);
        boolean synchronous = this.getSynchronous(connector, endpointURI);
        return new DefaultOutboundEndpoint(connector, endpointURI, transformers, responseTransformers, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getFilter(connector), this.getDefaultDeleteUnacceptedMessages(connector), this.getSecurityFilter(), synchronous, this.getResponseTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.name, this.muleContext, this.getRetryPolicyTemplate(connector), this.responsePropertiesList, this.getMessageProcessorsFactory(), this.messageProcessors, this.responseMessageProcessors);
    }

    protected boolean getSynchronous(Connector connector, EndpointURI endpointURI) {
        if (this.messageExchangePattern != null) {
            return this.messageExchangePattern.hasResponse();
        }
        return this.synchronous != null ? this.synchronous.booleanValue() : this.getDefaultSynchronous(connector, endpointURI.getScheme());
    }

    protected boolean getDefaultSynchronous(Connector connector, String protocol) {
        if (connector != null && connector.isSyncEnabled(protocol)) {
            return true;
        }
        return this.muleContext.getConfiguration().isDefaultSynchronousEndpoints();
    }

    protected RetryPolicyTemplate getRetryPolicyTemplate(Connector connector) {
        return this.retryPolicyTemplate != null ? this.retryPolicyTemplate : connector.getRetryPolicyTemplate();
    }

    protected TransactionConfig getTransactionConfig() {
        return this.transactionConfig != null ? this.transactionConfig : this.getDefaultTransactionConfig();
    }

    protected TransactionConfig getDefaultTransactionConfig() {
        return new MuleTransactionConfig();
    }

    protected EndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter != null ? this.securityFilter : this.getDefaultSecurityFilter();
    }

    protected EndpointSecurityFilter getDefaultSecurityFilter() {
        return null;
    }

    protected Connector getConnector() throws EndpointException {
        return this.connector != null ? this.connector : this.getDefaultConnector();
    }

    protected Connector getDefaultConnector() throws EndpointException {
        return this.getConnector(this.uriBuilder.getEndpoint(), this.muleContext);
    }

    protected String getName(EndpointURI endpointURI) {
        return this.name != null ? this.name : new ObjectNameHelper(this.muleContext).getEndpointName(endpointURI);
    }

    protected Map<Object, Object> getProperties() {
        LinkedList<Map<Object, Object>> maps = new LinkedList<Map<Object, Object>>();
        if (null != this.uriBuilder) {
            this.uriBuilder.setMuleContext(this.muleContext);
            maps.addLast(this.uriBuilder.getEndpoint().getParams());
        }
        if (this.properties != null) {
            maps.addLast(this.properties);
        }
        MapCombiner combiner = new MapCombiner();
        combiner.setList(maps);
        return Collections.unmodifiableMap(combiner);
    }

    protected boolean getDeleteUnacceptedMessages(Connector connector) {
        return this.deleteUnacceptedMessages != null ? this.deleteUnacceptedMessages.booleanValue() : this.getDefaultDeleteUnacceptedMessages(connector);
    }

    protected boolean getDefaultDeleteUnacceptedMessages(Connector connector) {
        return false;
    }

    protected String getEndpointEncoding(Connector connector) {
        return this.encoding != null ? this.encoding : this.getDefaultEndpointEncoding(connector);
    }

    protected String getDefaultEndpointEncoding(Connector connector) {
        return this.muleContext.getConfiguration().getDefaultEncoding();
    }

    protected Filter getFilter(Connector connector) {
        return this.filter != null ? this.filter : this.getDefaultFilter(connector);
    }

    protected Filter getDefaultFilter(Connector connector) {
        return null;
    }

    protected String getInitialState(Connector connector) {
        return this.initialState != null ? this.initialState : this.getDefaultInitialState(connector);
    }

    protected String getDefaultInitialState(Connector connector) {
        return "started";
    }

    protected int getResponseTimeout(Connector connector) {
        return this.responseTimeout != null ? this.responseTimeout.intValue() : this.getDefaultResponseTimeout(connector);
    }

    protected int getDefaultResponseTimeout(Connector connector) {
        return this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected List<Transformer> getInboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.transformers != null) {
            return this.transformers;
        }
        List<Transformer> transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultInboundTransformers(connector);
    }

    protected List<Transformer> getDefaultInboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultInboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List<Transformer> getOutboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.transformers != null) {
            return this.transformers;
        }
        List<Transformer> transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultOutboundTransformers(connector);
    }

    protected List<Transformer> getDefaultOutboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultOutboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List<Transformer> getInboundEndpointResponseTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.responseTransformers != null) {
            return this.responseTransformers;
        }
        List<Transformer> transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultResponseTransformers(connector);
    }

    protected List<Transformer> getOutboundEndpointResponseTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.responseTransformers != null) {
            return this.responseTransformers;
        }
        List<Transformer> transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (transformers != null) {
            return transformers;
        }
        return Collections.emptyList();
    }

    protected List<Transformer> getDefaultResponseTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultResponseTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    private List<Transformer> getTransformersFromString(String transformers) throws TransportFactoryException {
        try {
            return TransformerUtils.getTransformers(transformers, this.muleContext);
        }
        catch (DefaultMuleException e) {
            throw new TransportFactoryException(e);
        }
    }

    private Properties getOverrides(Connector connector) {
        Map so;
        Properties overrides = new Properties();
        if (connector instanceof AbstractConnector && (so = ((AbstractConnector)connector).getServiceOverrides()) != null) {
            overrides.putAll((Map<?, ?>)so);
        }
        return overrides;
    }

    private TransportServiceDescriptor getNonNullServiceDescriptor(String scheme, Properties overrides) throws ServiceException {
        TransportServiceDescriptor sd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, overrides);
        if (null != sd) {
            return sd;
        }
        throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
    }

    private Connector getConnector(EndpointURI endpointURI, MuleContext muleContext) throws EndpointException {
        Connector connector;
        String scheme = this.uriBuilder.getEndpoint().getFullScheme();
        TransportFactory factory = new TransportFactory(muleContext);
        try {
            if (this.uriBuilder.getEndpoint().getConnectorName() != null) {
                connector = muleContext.getRegistry().lookupConnector(this.uriBuilder.getEndpoint().getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", this.uriBuilder.getEndpoint().getConnectorName()));
                }
            } else if (this.isAlwaysCreateConnector()) {
                connector = factory.createConnector(endpointURI);
                muleContext.getRegistry().registerConnector(connector);
            } else {
                connector = factory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = factory.createConnector(endpointURI);
                    muleContext.getRegistry().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "endpointURI: " + endpointURI);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        return connector;
    }

    protected boolean isAlwaysCreateConnector() {
        return false;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public void addTransformer(Transformer transformer) {
        if (this.transformers == null) {
            this.transformers = new LinkedList<Transformer>();
        }
        this.transformers.add(transformer);
    }

    @Override
    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    protected EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.messageProcessorsFactory != null ? this.messageProcessorsFactory : this.getDefaultMessageProcessorsFactory();
    }

    protected EndpointMessageProcessorChainFactory getDefaultMessageProcessorsFactory() {
        return new DefaultEndpointMessageProcessorChainFactory();
    }

    @Override
    public void addResponseTransformer(Transformer transformer) {
        if (this.responseTransformers == null) {
            this.responseTransformers = new LinkedList<Transformer>();
        }
        this.responseTransformers.add(transformer);
    }

    @Override
    public void setResponseTransformers(List<Transformer> transformers) {
        this.responseTransformers = transformers;
    }

    @Override
    public void addMessageProcessor(MessageProcessor messageProcessor) {
        if (this.messageProcessors == null) {
            this.messageProcessors = new LinkedList<MessageProcessor>();
        }
        this.messageProcessors.add(messageProcessor);
    }

    @Override
    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void addResponseMessageProcessor(MessageProcessor messageProcessor) {
        if (this.responseMessageProcessors == null) {
            this.responseMessageProcessors = new LinkedList<MessageProcessor>();
        }
        this.responseMessageProcessors.add(messageProcessor);
    }

    @Override
    public void setResponseMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.responseMessageProcessors = messageProcessors;
    }

    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.responseMessageProcessors;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        if (null == this.properties) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.putAll(properties);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setDeleteUnacceptedMessages(boolean deleteUnacceptedMessages) {
        this.deleteUnacceptedMessages = deleteUnacceptedMessages;
    }

    @Override
    public void setSecurityFilter(EndpointSecurityFilter securityFilter) {
        this.securityFilter = securityFilter;
    }

    @Override
    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public void setExchangePattern(MessageExchangePattern mep) {
        this.messageExchangePattern = mep;
    }

    @Override
    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = new Integer(responseTimeout);
    }

    @Override
    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCreateConnector(int createConnector) {
        this.createConnector = new Integer(createConnector);
    }

    @Override
    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public URIBuilder getEndpointBuilder() {
        return this.uriBuilder;
    }

    @Override
    public void setURIBuilder(URIBuilder URIBuilder2) {
        this.uriBuilder = URIBuilder2;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.retryPolicyTemplate, this.connector, this.createConnector, this.deleteUnacceptedMessages, this.encoding, this.uriBuilder, this.filter, this.initialState, this.name, this.properties, this.responseTimeout, this.responseTransformers, this.securityFilter, this.synchronous, this.messageExchangePattern, this.transactionConfig, this.transformers});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpointBuilder other = (AbstractEndpointBuilder)obj;
        return AbstractEndpointBuilder.equal(this.retryPolicyTemplate, other.retryPolicyTemplate) && AbstractEndpointBuilder.equal(this.connector, other.connector) && AbstractEndpointBuilder.equal(this.createConnector, other.createConnector) && AbstractEndpointBuilder.equal(this.deleteUnacceptedMessages, other.deleteUnacceptedMessages) && AbstractEndpointBuilder.equal(this.encoding, other.encoding) && AbstractEndpointBuilder.equal(this.uriBuilder, other.uriBuilder) && AbstractEndpointBuilder.equal(this.filter, other.filter) && AbstractEndpointBuilder.equal(this.initialState, other.initialState) && AbstractEndpointBuilder.equal(this.name, other.name) && AbstractEndpointBuilder.equal(this.properties, other.properties) && AbstractEndpointBuilder.equal(this.responseTimeout, other.responseTimeout) && AbstractEndpointBuilder.equal(this.responseTransformers, other.responseTransformers) && AbstractEndpointBuilder.equal(this.securityFilter, other.securityFilter) && AbstractEndpointBuilder.equal(this.synchronous, other.synchronous) && AbstractEndpointBuilder.equal((Object)this.messageExchangePattern, (Object)other.messageExchangePattern) && AbstractEndpointBuilder.equal(this.transactionConfig, other.transactionConfig) && AbstractEndpointBuilder.equal(this.transformers, other.transformers);
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EndpointBuilder builder = (EndpointBuilder)super.clone();
        builder.setConnector(this.connector);
        builder.setURIBuilder(this.uriBuilder);
        builder.setTransformers(this.transformers);
        builder.setResponseTransformers(this.responseTransformers);
        builder.setName(this.name);
        builder.setProperties(this.properties);
        builder.setTransactionConfig(this.transactionConfig);
        builder.setFilter(this.filter);
        builder.setSecurityFilter(this.securityFilter);
        builder.setInitialState(this.initialState);
        builder.setEncoding(this.encoding);
        builder.setRegistryId(this.registryId);
        builder.setMuleContext(this.muleContext);
        builder.setRetryPolicyTemplate(this.retryPolicyTemplate);
        if (this.deleteUnacceptedMessages != null) {
            builder.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        }
        if (this.messageExchangePattern != null) {
            builder.setExchangePattern(this.messageExchangePattern);
        }
        if (this.responseTimeout != null) {
            builder.setResponseTimeout(this.responseTimeout);
        }
        return builder;
    }
}

