/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.routers;

import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class ContentBasedRouter
extends AbstractOutboundRouter {
    public MuleEvent route(MuleEvent theEvent) throws MessagingException {
        MuleMessage message = theEvent.getMessage();
        MuleSession session = theEvent.getSession();
        for (OutboundEndpoint endpoint : this.endpoints) {
            if (!this.isMatch(message)) continue;
            try {
                DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, session);
                if (endpoint.isSynchronous()) {
                    return endpoint.process(event);
                }
                endpoint.process(event);
                return null;
            }
            catch (MuleException e) {
                throw new MessagingException(e.getI18nMessage(), message, e);
            }
        }
        throw new RuntimeException("Event not processed");
    }

    public boolean isMatch(MuleMessage message) throws MessagingException {
        for (OutboundEndpoint endpoint : this.endpoints) {
            if (endpoint.getFilter() != null && !endpoint.getFilter().accept(message)) continue;
            return true;
        }
        return false;
    }
}

