/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEventContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.InterfaceBinding;
import org.mule.component.ComponentException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.registry.JSR250ValidatorProcessor;
import org.mule.routing.binding.BindingInvocationHandler;
import org.mule.util.ClassUtils;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class DefaultComponentLifecycleAdapter
implements LifecycleAdapter {
    protected static final Log logger = LogFactory.getLog(DefaultComponentLifecycleAdapter.class);
    protected SoftReference<?> componentObject;
    private String componentObjectRegistryKey;
    protected JavaComponent component;
    protected EntryPointResolverSet entryPointResolver;
    protected FlowConstruct flowConstruct;
    protected boolean isInitialisable = false;
    protected boolean isStartable = false;
    protected boolean isStoppable = false;
    protected boolean isDisposable = false;
    protected Method initMethod;
    protected Method disposeMethod;
    private boolean started = false;
    private boolean disposed = false;
    protected MuleContext muleContext;

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, MuleContext muleContext) throws MuleException {
        if (muleContext == null) {
            throw new IllegalStateException("No muleContext provided");
        }
        if (componentObject == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (this.entryPointResolver == null) {
            this.entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.componentObject = new SoftReference<Object>(componentObject);
        this.component = component;
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
        this.registerComponentIfNecessary();
        this.setLifecycleFlags();
        this.configureBinding();
    }

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, EntryPointResolverSet entryPointResolver, MuleContext muleContext) throws MuleException {
        this(componentObject, component, flowConstruct, muleContext);
        this.entryPointResolver = entryPointResolver;
    }

    protected void setLifecycleFlags() {
        Object object = this.componentObject.get();
        this.initMethod = this.findInitMethod(object);
        this.disposeMethod = this.findDisposeMethod(object);
        this.isInitialisable = this.initMethod != null;
        this.isDisposable = this.disposeMethod != null;
        this.isStartable = Startable.class.isInstance(object);
        this.isStoppable = Stoppable.class.isInstance(object);
    }

    protected Method findInitMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Initialisable) {
            try {
                return object.getClass().getMethod("initialise", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PostConstruct.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePostConstructAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    protected Method findDisposeMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Disposable) {
            try {
                return object.getClass().getMethod("dispose", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PreDestroy.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePreDestroyAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    protected void registerComponentIfNecessary() throws RegistrationException {
        MuleRegistry r = this.muleContext.getRegistry();
        this.componentObjectRegistryKey = this.createRegistryHardRefName(this.component);
        if (r.lookupObjects(this.componentObject.get().getClass()).size() == 0) {
            r.registerObject(this.componentObjectRegistryKey, this.componentObject.get(), 5);
        }
    }

    public void initialise() throws InitialisationException {
        if (this.isInitialisable) {
            try {
                this.initMethod.invoke(this.componentObject.get(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
            catch (InvocationTargetException e) {
                throw new InitialisationException(e.getTargetException(), (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
        if (this.isStartable) {
            try {
                ((Startable)this.componentObject.get()).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.componentObject.get()).stop();
                this.started = false;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = false;
        }
    }

    public void dispose() {
        try {
            Object o;
            if (this.isDisposable && (o = this.componentObject.get()) != null) {
                try {
                    this.disposeMethod.invoke(o, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            this.muleContext.getRegistry().unregisterObject(this.componentObjectRegistryKey);
            this.componentObject.clear();
            this.componentObject.enqueue();
        }
        catch (Throwable e) {
            logger.error((Object)("failed to dispose: " + this.flowConstruct.getName()), e);
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Object invoke(MuleEvent event) throws MuleException {
        Object result;
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(event);
        try {
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.componentObject.get(), eventContext) : this.entryPointResolver.invoke(this.componentObject.get(), eventContext);
        }
        catch (Exception e) {
            throw new ComponentException(RequestContext.getEventContext().getMessage(), this.component, (Throwable)e);
        }
        return result;
    }

    protected void configureBinding() throws MuleException {
        if (this.component.getBindingCollection() != null) {
            HashMap bindings = new HashMap();
            for (InterfaceBinding interfaceBinding : this.component.getBindingCollection().getRouters()) {
                Object proxy = bindings.get(interfaceBinding.getInterface());
                if (proxy == null) {
                    proxy = interfaceBinding.createProxy(this.componentObject.get());
                    bindings.put(interfaceBinding.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.componentObject.get().getClass(), new Class[]{interfaceBinding.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.componentObject.get().getClass(), new Class[]{interfaceBinding.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.componentObject.get().getClass(), new Class[]{interfaceBinding.getInterface()});
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.componentObject.get(), proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(interfaceBinding, this.componentObject.get().getClass()), (Throwable)e, this);
                    }
                }
                BindingInvocationHandler handler = (BindingInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(interfaceBinding);
            }
        }
    }

    protected String createRegistryHardRefName(Object object) {
        return "_component.hardref." + this.flowConstruct.getName() + "." + System.identityHashCode(object);
    }
}

