/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.FutureMessageResult;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transformer.TransformerException;
import org.mule.transaction.TransactionCoordination;

public class DefaultMuleEventContext
implements MuleEventContext {
    protected static final Log logger = LogFactory.getLog(DefaultMuleEventContext.class);
    private final MuleEvent event;
    private final MuleSession session;

    public DefaultMuleEventContext(MuleEvent event) {
        this.event = event;
        this.session = event.getSession();
    }

    public MuleMessage getMessage() {
        return this.event.getMessage();
    }

    public byte[] getMessageAsBytes() throws MuleException {
        return this.event.getMessageAsBytes();
    }

    public Object transformMessage() throws TransformerException {
        return this.event.transformMessage();
    }

    public Object transformMessage(Class expectedType) throws TransformerException {
        return this.event.transformMessage(expectedType);
    }

    public byte[] transformMessageToBytes() throws TransformerException {
        return this.event.transformMessageToBytes();
    }

    public String getMessageAsString(String encoding) throws MuleException {
        return this.event.getMessageAsString(encoding);
    }

    public String transformMessageToString() throws TransformerException {
        return this.event.transformMessageToString();
    }

    public String getMessageAsString() throws MuleException {
        return this.event.getMessageAsString();
    }

    public Transaction getCurrentTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public void markTransactionForRollback() throws TransactionException {
        if (this.getCurrentTransaction() != null) {
            this.getCurrentTransaction().setRollbackOnly();
        }
    }

    public MuleMessage sendEvent(Object message) throws MuleException {
        return this.sendEvent(new DefaultMuleMessage(message, this.event.getMessage(), this.event.getMuleContext()));
    }

    public MuleMessage sendEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        return this.session.sendEvent(message, endpoint);
    }

    public MuleMessage sendEvent(MuleMessage message) throws MuleException {
        return this.session.sendEvent(message);
    }

    public MuleMessage sendEvent(MuleMessage message, EndpointURI endpointUri) throws MuleException {
        OutboundEndpoint endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointUri);
        return this.session.sendEvent(message, endpoint);
    }

    public FutureMessageResult sendEventAsync(final Object message, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                DefaultMuleMessage muleMessage = new DefaultMuleMessage(message, DefaultMuleEventContext.this.event.getMessage(), DefaultMuleEventContext.this.event.getMuleContext());
                muleMessage.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(muleMessage);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final MuleMessage message, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final MuleMessage message, final EndpointURI endpointUri, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message, endpointUri);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final MuleMessage message, final String endpointName, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message, endpointName);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    public MuleMessage sendEvent(MuleMessage message, String endpointName) throws MuleException {
        OutboundEndpoint endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName);
        return this.session.sendEvent(message, endpoint);
    }

    public void dispatchEvent(Object message) throws MuleException {
        this.session.dispatchEvent(new DefaultMuleMessage(message, this.event.getMessage(), this.event.getMuleContext()));
    }

    public void dispatchEvent(MuleMessage message) throws MuleException {
        this.session.dispatchEvent(message);
    }

    public void dispatchEvent(MuleMessage message, EndpointURI endpointUri) throws MuleException {
        OutboundEndpoint endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointUri);
        this.session.dispatchEvent(message, endpoint);
    }

    public void dispatchEvent(MuleMessage message, String endpointName) throws MuleException {
        this.session.dispatchEvent(message, endpointName);
    }

    public void dispatchEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        this.session.dispatchEvent(message, endpoint);
    }

    public MuleMessage requestEvent(InboundEndpoint endpoint, long timeout) throws MuleException {
        return this.session.requestEvent(endpoint, timeout);
    }

    public MuleMessage requestEvent(String endpointName, long timeout) throws MuleException {
        return this.session.requestEvent(endpointName, timeout);
    }

    public MuleMessage requestEvent(EndpointURI endpointUri, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointUri);
        return this.session.requestEvent(endpoint, timeout);
    }

    public FlowConstruct getFlowConstruct() {
        return this.event.getFlowConstruct();
    }

    public boolean isStopFurtherProcessing() {
        return RequestContext.getEvent().isStopFurtherProcessing();
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.event.setStopFurtherProcessing(stopFurtherProcessing);
    }

    public OutputStream getOutputStream() {
        return this.event.getOutputStream();
    }

    public boolean isSynchronous() {
        return this.event.isSynchronous();
    }

    public EndpointURI getEndpointURI() {
        return this.event.getEndpoint().getEndpointURI();
    }

    public Transaction getTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public int getTimeout() {
        return this.event.getTimeout();
    }

    public String getEncoding() {
        return this.event.getEncoding();
    }

    public MuleSession getSession() {
        return this.event.getSession();
    }

    public String toString() {
        return this.event.toString();
    }

    public MuleContext getMuleContext() {
        return this.event.getMuleContext();
    }
}

