/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.pool;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.object.ObjectFactory;
import org.mule.config.PoolingProfile;
import org.mule.util.pool.CommonsPoolObjectPool;
import org.mule.util.pool.LifecyleEnabledObjectPool;

public class DefaultLifecycleEnabledObjectPool
extends CommonsPoolObjectPool
implements LifecyleEnabledObjectPool {
    protected static final Log logger = LogFactory.getLog(DefaultLifecycleEnabledObjectPool.class);
    protected AtomicBoolean started = new AtomicBoolean(false);
    private List items = new LinkedList();

    public DefaultLifecycleEnabledObjectPool(ObjectFactory objectFactory, PoolingProfile poolingProfile, MuleContext muleContext) {
        super(objectFactory, poolingProfile, muleContext);
    }

    protected PoolableObjectFactory getPooledObjectFactory() {
        return new LifecycleEnabledPoolabeObjectFactoryAdaptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MuleException {
        this.started.set(true);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Startable)i.next()).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MuleException {
        this.started.set(false);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Stoppable)i.next()).stop();
            }
        }
    }

    class LifecycleEnabledPoolabeObjectFactoryAdaptor
    implements PoolableObjectFactory {
        LifecycleEnabledPoolabeObjectFactoryAdaptor() {
        }

        public void activateObject(Object obj) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object obj) throws Exception {
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if (obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.remove(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject() throws Exception {
            Object object = DefaultLifecycleEnabledObjectPool.this.objectFactory.getInstance(DefaultLifecycleEnabledObjectPool.this.muleContext);
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && object instanceof Startable) {
                ((Startable)object).start();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.add(object);
            }
            return object;
        }

        public void passivateObject(Object obj) throws Exception {
        }

        public boolean validateObject(Object obj) {
            return true;
        }
    }
}

