/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    public static <T> T[] toArrayOfComponentType(Collection objects, Class<T> clazz) {
        if (objects == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Array target class must not be null");
        }
        if (objects.isEmpty()) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        int i = 0;
        int size = objects.size();
        Object[] result = (Object[])Array.newInstance(clazz, size);
        Iterator iter = objects.iterator();
        while (i < size && iter.hasNext()) {
            result[i++] = iter.next();
        }
        return result;
    }

    public static String toString(Collection c, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        return CollectionUtils.toString(c, c.size(), newline);
    }

    public static String toString(Collection c, int maxElements) {
        return CollectionUtils.toString(c, maxElements, false);
    }

    public static String toString(Collection c, int maxElements, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        int origNumElements = c.size();
        int numElements = Math.min(origNumElements, maxElements);
        boolean tooManyElements = origNumElements > maxElements;
        StringBuffer buf = new StringBuffer(numElements * 32);
        buf.append('[');
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        Iterator items = c.iterator();
        for (int i = 0; i < numElements - 1; ++i) {
            Object item = items.next();
            if (item instanceof Class) {
                buf.append(((Class)item).getName());
            } else {
                buf.append(item);
            }
            if (newline) {
                buf.append(SystemUtils.LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        Object lastItem = items.next();
        if (lastItem instanceof Class) {
            buf.append(((Class)lastItem).getName());
        } else {
            buf.append(lastItem);
        }
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        if (tooManyElements) {
            buf.append(" [..]");
        }
        buf.append(']');
        return buf.toString();
    }

    public static List addCreate(List list, Object value) {
        if (null == list) {
            return CollectionUtils.singletonList(value);
        }
        list.add(value);
        return list;
    }

    public static List singletonList(Object value) {
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(value);
        return list;
    }
}

