/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;

public class KeyedPoolMessageDispatcherFactoryAdapter
implements MessageDispatcherFactory,
KeyedPoolableObjectFactory {
    private final MessageDispatcherFactory factory;

    public KeyedPoolMessageDispatcherFactoryAdapter(MessageDispatcherFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("factory").toString());
        }
        this.factory = factory;
    }

    public void activateObject(Object key, Object obj) throws Exception {
        OutboundEndpoint endpoint = (OutboundEndpoint)key;
        ((AbstractConnector)endpoint.getConnector()).getLifecycleManager().applyCompletedPhases(obj);
        this.factory.activate((OutboundEndpoint)key, (MessageDispatcher)obj);
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        this.factory.destroy((OutboundEndpoint)key, (MessageDispatcher)obj);
    }

    public Object makeObject(Object key) throws Exception {
        OutboundEndpoint endpoint = (OutboundEndpoint)key;
        MessageDispatcher dispatcher = this.factory.create(endpoint);
        ((AbstractConnector)endpoint.getConnector()).getLifecycleManager().applyCompletedPhases(dispatcher);
        return dispatcher;
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        this.factory.passivate((OutboundEndpoint)key, (MessageDispatcher)obj);
    }

    public boolean validateObject(Object key, Object obj) {
        return this.factory.validate((OutboundEndpoint)key, (MessageDispatcher)obj);
    }

    public boolean isCreateDispatcherPerRequest() {
        return this.factory.isCreateDispatcherPerRequest();
    }

    public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
        return this.factory.create(endpoint);
    }

    public void activate(OutboundEndpoint endpoint, MessageDispatcher dispatcher) throws MuleException {
        ((AbstractConnector)endpoint.getConnector()).getLifecycleManager().applyCompletedPhases(dispatcher);
        this.factory.activate(endpoint, dispatcher);
    }

    public void destroy(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        this.factory.destroy(endpoint, dispatcher);
    }

    public void passivate(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        this.factory.passivate(endpoint, dispatcher);
    }

    public boolean validate(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        return this.factory.validate(endpoint, dispatcher);
    }
}

