/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePair;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ConnectionNotification;
import org.mule.lifecycle.AbstractLifecycleManager;
import org.mule.transport.AbstractConnector;

public class ConnectorLifecycleManager
extends AbstractLifecycleManager {
    private AbstractConnector connector;

    public ConnectorLifecycleManager(AbstractConnector connector, LifecycleManager lifecycleManager) throws MuleException {
        this.connector = connector;
        for (LifecyclePair pair : lifecycleManager.getLifecyclePairs()) {
            this.registerLifecycle(pair);
        }
    }

    public void fireLifecycle(String phase) throws LifecycleException {
        this.checkPhase(phase);
        LifecyclePhase li = this.getPhaseForIndex(this.getPhaseIndex(phase));
        this.invokePhase(li);
    }

    protected void doApplyPhase(LifecyclePhase phase) throws LifecycleException {
        block7: {
            try {
                if (phase.getName().equals("initialise")) {
                    logger.debug((Object)("Initialising connector: " + this.connector.getName()));
                    this.connector.doInitialise();
                    break block7;
                }
                if (phase.getName().equals("start")) {
                    logger.debug((Object)("Starting connector: " + this.connector.getName()));
                    this.connector.doStart();
                    break block7;
                }
                if (phase.getName().equals("stop")) {
                    logger.debug((Object)("Stopping connector: " + this.connector.getName()));
                    this.connector.doStop();
                    break block7;
                }
                if (phase.getName().equals("dispose")) {
                    logger.debug((Object)("Disposing connector: " + this.connector.getName()));
                    if (this.getState().isStarted()) {
                        this.setExecutingPhase(null);
                        this.connector.stop();
                    }
                    this.connector.doDispose();
                    break block7;
                }
                throw new LifecycleException(CoreMessages.lifecyclePhaseNotRecognised(phase.getName()), (Object)this.connector);
            }
            catch (MuleException e) {
                throw new LifecycleException(e, (Object)this.connector);
            }
        }
    }

    protected void fireConnectionNotification(int action) {
        this.connector.getMuleContext().fireNotification(new ConnectionNotification(this.connector, this.connector.getName(), action));
    }
}

