/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.transport.SessionHandler;

public class SerializeOnlySessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        MuleSession session = null;
        byte[] serializedSession = (byte[])message.removeProperty("MULE_SESSION");
        if (serializedSession != null) {
            session = (MuleSession)SerializationUtils.deserialize((byte[])serializedSession);
        }
        return session;
    }

    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        byte[] serializedSession = SerializationUtils.serialize((Serializable)session);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized Session header to message: " + serializedSession));
        }
        message.setProperty("MULE_SESSION", serializedSession);
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

