/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePair;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ServiceNotification;
import org.mule.lifecycle.AbstractLifecycleManager;
import org.mule.lifecycle.DefaultLifecyclePair;
import org.mule.service.AbstractService;
import org.mule.service.PausePhase;
import org.mule.service.ResumePhase;

public class ServiceLifecycleManager
extends AbstractLifecycleManager {
    protected final transient Log logger = LogFactory.getLog(ServiceLifecycleManager.class);
    private AbstractService service;

    public ServiceLifecycleManager(AbstractService service, LifecycleManager lifecycleManager) throws MuleException {
        this.service = service;
        for (LifecyclePair pair : lifecycleManager.getLifecyclePairs()) {
            this.registerLifecycle(pair);
        }
        this.registerLifecycle(new DefaultLifecyclePair(new PausePhase(), new ResumePhase()));
    }

    public void fireLifecycle(String phase) throws LifecycleException {
        this.checkPhase(phase);
        LifecyclePhase li = this.getPhaseForIndex(this.getPhaseIndex(phase));
        this.invokePhase(li);
    }

    protected void doApplyPhase(LifecyclePhase phase) throws LifecycleException {
        block10: {
            try {
                if (phase.getName().equals("initialise")) {
                    this.logger.debug((Object)("Initialising service: " + this.service.getName()));
                    this.service.doInitialise();
                    this.fireServiceNotification(301);
                    break block10;
                }
                if (phase.getName().equals("start")) {
                    this.logger.debug((Object)("Starting service: " + this.service.getName()));
                    this.service.doStart();
                    this.fireServiceNotification(302);
                    break block10;
                }
                if (phase.getName().equals("pause")) {
                    this.logger.debug((Object)("Pausing service: " + this.service.getName()));
                    this.service.doPause();
                    this.fireServiceNotification(304);
                    break block10;
                }
                if (phase.getName().equals("resume")) {
                    this.logger.debug((Object)("Resuming service: " + this.service.getName()));
                    this.service.doResume();
                    this.fireServiceNotification(305);
                    break block10;
                }
                if (phase.getName().equals("stop")) {
                    this.logger.debug((Object)("Stopping service: " + this.service.getName()));
                    this.service.doStop();
                    this.fireServiceNotification(303);
                    break block10;
                }
                if (phase.getName().equals("dispose")) {
                    this.logger.debug((Object)("Disposing service: " + this.service.getName()));
                    if (this.getState().isPhaseComplete("pause")) {
                        this.setExecutingPhase(null);
                        this.service.resume();
                    }
                    if (this.getState().isStarted()) {
                        this.setExecutingPhase(null);
                        this.service.stop();
                    }
                    this.service.doDispose();
                    this.fireServiceNotification(306);
                    break block10;
                }
                throw new LifecycleException(CoreMessages.lifecyclePhaseNotRecognised(phase.getName()), (Object)this.service);
            }
            catch (MuleException e) {
                throw new LifecycleException(e, (Object)this.service);
            }
        }
    }

    protected void fireServiceNotification(int action) {
        this.service.getMuleContext().fireNotification(new ServiceNotification(this.service, action));
    }
}

