/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;

public class MessageChunkingRouter
extends FilteringOutboundRouter {
    private int messageSize = 0;
    private int numberOfMessages = 1;

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public void setNumberOfMessages(int numberOfMessages) {
        this.numberOfMessages = numberOfMessages;
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        if (this.messageSize == 0 && this.numberOfMessages < 2) {
            return super.route(message, session);
        }
        if (this.messageSize > 0) {
            byte[] data = new byte[]{};
            try {
                data = message.getPayloadAsBytes();
            }
            catch (Exception e) {
                throw new RoutingException(CoreMessages.failedToReadPayload(), message, this.getEndpoint(0, message), e);
            }
            int parts = data.length / this.messageSize;
            if (parts * this.messageSize < data.length) {
                ++parts;
            }
            int len = this.messageSize;
            DefaultMuleMessage part = null;
            int pos = 0;
            byte[] buffer = null;
            try {
                for (int count = 0; count < parts; ++count) {
                    if (pos + len > data.length) {
                        len = data.length - pos;
                    }
                    buffer = new byte[len];
                    System.arraycopy(data, pos, buffer, 0, buffer.length);
                    pos += len;
                    part = new DefaultMuleMessage((Object)buffer, message, this.muleContext);
                    part.setCorrelationId(message.getUniqueId());
                    part.setCorrelationGroupSize(parts);
                    part.setCorrelationSequence(count);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("sending part " + count + " of " + parts));
                    }
                    super.route(part, session);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)"sent");
                }
            }
            catch (RoutingException e) {
                e = new RoutingException(e.getI18nMessage(), e.getMuleMessage(), e.getEndpoint(), e.getCause());
                throw e;
            }
        }
        return message;
    }
}

