/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.outbound.AbstractRoundRobinMessageSplitter;

public class ExpressionMessageSplitter
extends AbstractRoundRobinMessageSplitter {
    protected ExpressionConfig config = new ExpressionConfig();

    public ExpressionMessageSplitter() {
    }

    public ExpressionMessageSplitter(ExpressionConfig config) {
        this.config = config;
        if (this.config.getEvaluator().equals("xpath")) {
            this.config.setEvaluator("xpath-node");
        }
    }

    public String getCustomEvaluator() {
        return this.config.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.config.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.config.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        if (evaluator.equals("xpath")) {
            evaluator = "xpath-node";
        }
        this.config.setEvaluator(evaluator);
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        this.config.validate(this.expressionManager);
    }

    protected List splitMessage(MuleMessage message) {
        ArrayList<Object> results = new ArrayList<Object>(4);
        Object result = this.muleContext.getExpressionManager().evaluate(this.config.getFullExpression(this.expressionManager), message);
        if (result instanceof List) {
            results.addAll((List)result);
        } else {
            results.add(result);
            this.logger.warn((Object)"Splitter only returned a single result. If this is not expected, please check your split expression");
        }
        return results;
    }
}

