/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouterCollection;
import org.mule.transaction.TransactionTemplate;

public class DefaultOutboundRouterCollection
extends AbstractRouterCollection
implements OutboundRouterCollection {
    public DefaultOutboundRouterCollection() {
        super(2);
    }

    public MuleMessage route(MuleMessage message, final MuleSession session) throws MessagingException {
        boolean matchfound = false;
        Iterator<Router> iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            MuleMessage result;
            MuleMessage outboundRouterMessage;
            OutboundRouter outboundRouter = (OutboundRouter)iterator.next();
            if (iterator.hasNext() && (this.isMatchAll() || outboundRouter.isRequiresNewMessage())) {
                if (((DefaultMuleMessage)message).isConsumable()) {
                    throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), message);
                }
                outboundRouterMessage = new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
            } else {
                outboundRouterMessage = message;
            }
            if (!outboundRouter.isMatch(outboundRouterMessage)) continue;
            matchfound = true;
            final OutboundRouter router = outboundRouter;
            TransactionTemplate tt = new TransactionTemplate(outboundRouter.getTransactionConfig(), session.getService().getExceptionListener(), this.muleContext);
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    return router.route(outboundRouterMessage, session);
                }
            };
            try {
                result = (MuleMessage)tt.execute(cb);
            }
            catch (Exception e) {
                throw new RoutingException(outboundRouterMessage, null, (Throwable)e);
            }
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + session.getService().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(message, session);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + session.getService().getName() + " and there is no catch all strategy configured on this router.  Disposing message " + message));
        }
        return message;
    }

    protected MuleMessage catchAll(MuleMessage message, MuleSession session) throws RoutingException {
        if (this.getStatistics().isEnabled()) {
            this.getStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().catchMessage(message, session);
    }

    public boolean hasEndpoints() {
        for (OutboundRouter router : this.routers) {
            if (router.getEndpoints().size() <= 0 && !router.isDynamicEndpoints()) continue;
            return true;
        }
        return false;
    }
}

