/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.text.MessageFormat;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.util.store.InMemoryObjectStore;

public class IdempotentReceiver
extends SelectiveConsumer {
    protected volatile ObjectStore store;
    protected volatile String assignedComponentName;
    protected String idExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");

    protected void initialize(MuleEvent event) throws RoutingException {
        if (this.assignedComponentName == null) {
            this.assignedComponentName = event.getService().getName();
        }
        if (this.store == null) {
            try {
                this.store = this.createMessageIdStore();
            }
            catch (InitialisationException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
    }

    protected ObjectStore createMessageIdStore() throws InitialisationException {
        InMemoryObjectStore s = new InMemoryObjectStore();
        s.setName(this.assignedComponentName);
        s.setMaxEntries(-1);
        s.setEntryTTL(300000);
        s.setExpirationInterval(6000);
        s.initialise();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMatch(MuleEvent event) throws MessagingException {
        if (!super.isMatch(event)) {
            return false;
        }
        if (this.store == null || this.assignedComponentName == null) {
            IdempotentReceiver idempotentReceiver = this;
            synchronized (idempotentReceiver) {
                this.initialize(event);
            }
        }
        try {
            return !this.store.containsObject(this.getIdForEvent(event));
        }
        catch (Exception ex) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)ex);
        }
    }

    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        String eventComponentName = event.getService().getName();
        if (!this.assignedComponentName.equals(eventComponentName)) {
            IllegalArgumentException iex = new IllegalArgumentException("This receiver is assigned to service: " + this.assignedComponentName + " but has received an event for service: " + eventComponentName + ". Please check your config to make sure each service" + "has its own instance of IdempotentReceiver.");
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)iex);
        }
        String id = this.getIdForEvent(event);
        try {
            if (this.store.storeObject(id, id)) {
                return new MuleEvent[]{event};
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToWriteMessageToStore(id, this.assignedComponentName), event.getMessage(), event.getEndpoint(), e);
        }
    }

    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        return this.muleContext.getExpressionManager().parse(this.idExpression, event.getMessage(), true);
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore getStore() {
        return this.store;
    }

    public void setStore(ObjectStore store) {
        this.store = store;
    }
}

