/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.registry.InjectProcessor;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.PreInitProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.registry.AbstractRegistry;
import org.mule.registry.ExpressionEvaluatorProcessor;
import org.mule.registry.LifecycleStateInjectorProcessor;
import org.mule.registry.MuleContextProcessor;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog(TransientRegistry.class);
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    private final Map<String, Object> registry;

    public TransientRegistry(MuleContext muleContext) {
        this(REGISTRY_ID, muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientRegistry(String id, MuleContext muleContext) {
        super(id, muleContext);
        Map<String, Object> map = this.registry = new HashMap<String, Object>();
        synchronized (map) {
            this.registry.put("_muleContextProcessor", new MuleContextProcessor(muleContext));
            this.registry.put("_muleExpressionEvaluatorProcessor", new ExpressionEvaluatorProcessor(muleContext));
            this.registry.put("_muleLifecycleStateInjectorProcessor", new LifecycleStateInjectorProcessor(this.getLifecycleManager().getState()));
            this.registry.put("_muleLifecycleManager", this.getLifecycleManager());
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.applyProcessors(this.lookupObjects(Connector.class), null);
        this.applyProcessors(this.lookupObjects(Transformer.class), null);
        this.applyProcessors(this.lookupObjects(ImmutableEndpoint.class), null);
        this.applyProcessors(this.lookupObjects(Agent.class), null);
        this.applyProcessors(this.lookupObjects(Model.class), null);
        this.applyProcessors(this.lookupObjects(Service.class), null);
        this.applyProcessors(this.lookupObjects(Object.class), null);
        try {
            this.getLifecycleManager().fireLifecycle("initialise");
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    protected void doDispose() {
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
        }
        catch (MuleException e) {
            this.logger.warn((Object)"Failed to dipose the registry cleanly", (Throwable)e);
        }
    }

    protected Map applyProcessors(Map<String, Object> objects) {
        if (objects == null) {
            return null;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            Collection<ObjectProcessor> processors = this.lookupObjects(ObjectProcessor.class);
            for (ObjectProcessor processor : processors) {
                Object result = processor.process(entry.getValue());
                if (result == null) continue;
                results.put(entry.getKey(), result);
            }
        }
        return results;
    }

    public void registerObjects(Map objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry entry : objects.entrySet()) {
            this.registerObject(entry.getKey().toString(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        Map<String, Object> map = this.registry;
        synchronized (map) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.registry.entrySet()) {
                Class<?> clazz = entry.getValue().getClass();
                if (!type.isAssignableFrom(clazz)) continue;
                results.put(entry.getKey(), entry.getValue());
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookupObject(String key) {
        Map<String, Object> map = this.registry;
        synchronized (map) {
            return (T)this.registry.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Collection<T> lookupObjects(Class<T> returntype) {
        Map<String, Object> map = this.registry;
        synchronized (map) {
            return CollectionUtils.select(this.registry.values(), (Predicate)new InstanceofPredicate(returntype));
        }
    }

    Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    Object applyProcessors(Object object, Object metadata) {
        Object theObject = object;
        if (!this.hasFlag(metadata, 2)) {
            Collection<InjectProcessor> injectProcessors = this.lookupObjects(InjectProcessor.class);
            for (InjectProcessor injectProcessor : injectProcessors) {
                theObject = injectProcessor.process(theObject);
            }
        }
        if (!this.hasFlag(metadata, 4)) {
            Collection<PreInitProcessor> processors = this.lookupObjects(PreInitProcessor.class);
            for (PreInitProcessor preInitProcessor : processors) {
                theObject = preInitProcessor.process(theObject);
                if (theObject != null) continue;
                return null;
            }
        }
        return theObject;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(String key, Object object, Object metadata) throws RegistrationException {
        this.checkDisposed();
        if (StringUtils.isBlank((String)key)) {
            throw new RegistrationException("Attempt to register object with no key");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("registering key/object %s/%s", key, object));
        }
        this.logger.debug((Object)"applying processors");
        object = this.applyProcessors(object, metadata);
        if (object == null) {
            return;
        }
        Map<String, Object> map = this.registry;
        synchronized (map) {
            if (this.registry.containsKey(key)) {
                this.logger.warn((Object)("TransientRegistry already contains an object named '" + key + "'.  The previous object will be overwritten."));
            }
            this.registry.put(key, object);
        }
        try {
            if (!this.hasFlag(metadata, 1)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("applying lifecycle to object: " + object));
                }
                this.getLifecycleManager().applyCompletedPhases(object);
            }
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    protected void checkDisposed() throws RegistrationException {
        if (this.getLifecycleManager().isPhaseComplete("dispose")) {
            throw new RegistrationException("Cannot register objects on the registry as the context is disposed");
        }
    }

    protected boolean hasFlag(Object metaData, int flag) {
        return metaData != null && metaData instanceof Integer && ((Integer)metaData & flag) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        Object obj;
        Map<String, Object> map = this.registry;
        synchronized (map) {
            obj = this.registry.remove(key);
        }
        try {
            this.getLifecycleManager().applyPhase(obj, "dispose");
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, Object.class);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

