/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.AbstractLifecycleManager;
import org.mule.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.lifecycle.LifecycleObject;

public class RegistryLifecycleManager
extends AbstractLifecycleManager {
    protected final transient Log logger = LogFactory.getLog(RegistryLifecycleManager.class);
    private Registry registry;

    public RegistryLifecycleManager(Registry registry) {
        this.registry = registry;
    }

    protected void doApplyPhase(LifecyclePhase phase) throws LifecycleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying lifecycle phase: " + phase.getName()));
        }
        if (phase instanceof ContainerManagedLifecyclePhase) {
            phase.applyLifecycle(this.registry);
            return;
        }
        HashSet duplicates = new HashSet();
        for (LifecycleObject lo : phase.getOrderedLifecycleObjects()) {
            Collection targetsObj = this.registry.lookupObjects(lo.getType());
            LinkedList targets = new LinkedList(targetsObj);
            if (targets.size() == 0) continue;
            lo.firePreNotification(this.muleContext);
            Iterator target = targets.iterator();
            while (target.hasNext()) {
                Object o = target.next();
                if (duplicates.contains(o)) {
                    target.remove();
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("lifecycle phase: " + phase.getName() + " for object: " + o));
                }
                phase.applyLifecycle(o);
                target.remove();
                duplicates.add(o);
            }
            lo.firePostNotification(this.muleContext);
        }
    }
}

